# Copyright 2022 RnD Center "ELVEES", JSC
#
# Based on https://github.com/corakwue/ftrace/tree/master/ftrace

from collections import namedtuple

TaskBase = namedtuple(
    "Task",
    [
        "name",  # Task name
        "pid",  # Process pid
    ],
)


class Task(TaskBase):

    __slots__ = ()

    def __new__(cls, name, pid, **kwargs):
        pid = int(pid) if pid else pid

        return super(Task, cls).__new__(
            cls,
            name=name,
            pid=pid,
        )

    def __repr__(self):
        return "Task(name={}, pid={}, )".format(self.name, self.pid)
