#!/bin/bash
#
# Copyright 2021 RnD Center "ELVEES", JSC
#
# UCG3 channel 5 uses for pixel clock purposes. But for correct working this
# clock must be same phase as real PIXCLK signal from UCG2 channel 2.
# If phases are very different and video does not work properly then we need to
# restart PLL3 to randomize clock phase.

button_prepare() {
    # Enable receiver for GPIO1_PORTD6/PORTD7
    devmem 0x17e0098 32 0x10f8
    devmem 0x17e009c 32 0x10f8
    local GPIOCHIPS
    GPIOCHIPS=$(ls -d /sys/class/gpio/gpiochip*)
    GPIOCHIP=""
    for DIR in $GPIOCHIPS; do
        if [ $(cat $DIR/label) == "1780000.gpio" ]; then
            GPIOCHIP=${DIR:24}
            break
        fi
    done
    if [ -z "$GPIOCHIP" ]; then
        echo "GPIO1_PORTD not found"
        exit 1
    fi
    GPIO_Y=/sys/class/gpio/gpio$((GPIOCHIP + 6))/value
    GPIO_N=/sys/class/gpio/gpio$((GPIOCHIP + 7))/value
    if [ ! -e $GPIO_Y ]; then
        echo $((GPIOCHIP + 6)) > /sys/class/gpio/export
    fi
    if [ ! -e $GPIO_N ]; then
        echo $((GPIOCHIP + 7)) > /sys/class/gpio/export
    fi
}

botton_get_gpio_yn() {
    answer=""
    echo -n "Output image is good? [left (PORTD_6) - yes, right (PORTD_7) - no] "
    while [ "$answer" != "y" ] && [ "$answer" != "n" ]; do
        local IS_Y
        IS_Y=$(cat $GPIO_Y)
        local IS_N
        IS_N=$(cat $GPIO_N)
        if [ "$IS_Y" == "1" ]; then
            answer="y"
        fi
        if [ "$IS_N" == "1" ]; then
            answer="n"
        fi
    done
}

key_get_yn() {
    answer=""
    while [ "$answer" != "y" ] && [ "$answer" != "n" ]; do
        read -n1 -r -p"Output image is good? [y/n] " answer
        echo ""
    done
}

BUTTON_CONTROL=n
if [ "$1" == "button" ]; then
    BUTTON_CONTROL=y
    button_prepare
fi
TESTIMAGE_FILE="/usr/share/pixmaps/gradient.png"

# If DISPLAY variable exists then don't use DRM (DRM doesn't work in X Window System)
if [ -n "$DISPLAY" ]; then
    ARG_VO=""
else
    ARG_VO="--vo=drm"
fi
mpv $ARG_VO --loop=inf $TESTIMAGE_FILE &> /dev/null &
PID=$!

answer=n
while [ "$answer" != "y" ]; do
    if [ "$BUTTON_CONTROL" == "y" ]; then
        botton_get_gpio_yn
    else
        key_get_yn
    fi

    if [ "$answer" == "n" ]; then
        echo "Restarting PLL..."
        mcom03-pixclk-pll-restart.sh
        sleep 2
    fi
done
echo ""

kill -s SIGINT $PID
