#!/bin/sh
BASE_DIR=$(realpath $(dirname $0))
cd $BASE_DIR
ROOT=$PWD
if [ "$1" = "--summary" ]; then
  OUTPUT=$BASE_DIR/output.log
  cat /dev/null > $OUTPUT
else
  OUTPUT=/dev/stdout
fi
export KSFT_TAP_LEVEL=1
export skip=4
echo ; echo TAP version 13
echo Running tests in android
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in android" >> /dev/kmsg
cd android
echo selftests: android: run.sh
(./run.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: android: run.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: android: run.sh [SKIP]"; else echo "not ok 1..1 selftests: android: run.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in bpf
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in bpf" >> /dev/kmsg
cd bpf
echo selftests: bpf: test_verifier
(./test_verifier >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: bpf: test_verifier [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: bpf: test_verifier [SKIP]"; else echo "not ok 1..1 selftests: bpf: test_verifier [FAIL]"; fi;)
echo selftests: bpf: test_tag
(./test_tag >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: bpf: test_tag [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: bpf: test_tag [SKIP]"; else echo "not ok 1..2 selftests: bpf: test_tag [FAIL]"; fi;)
echo selftests: bpf: test_maps
(./test_maps >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: bpf: test_maps [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: bpf: test_maps [SKIP]"; else echo "not ok 1..3 selftests: bpf: test_maps [FAIL]"; fi;)
echo selftests: bpf: test_lru_map
(./test_lru_map >> $OUTPUT 2>&1 && echo "ok 1..4 selftests: bpf: test_lru_map [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..4 selftests: bpf: test_lru_map [SKIP]"; else echo "not ok 1..4 selftests: bpf: test_lru_map [FAIL]"; fi;)
echo selftests: bpf: test_lpm_map
(./test_lpm_map >> $OUTPUT 2>&1 && echo "ok 1..5 selftests: bpf: test_lpm_map [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..5 selftests: bpf: test_lpm_map [SKIP]"; else echo "not ok 1..5 selftests: bpf: test_lpm_map [FAIL]"; fi;)
echo selftests: bpf: test_progs
(./test_progs >> $OUTPUT 2>&1 && echo "ok 1..6 selftests: bpf: test_progs [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..6 selftests: bpf: test_progs [SKIP]"; else echo "not ok 1..6 selftests: bpf: test_progs [FAIL]"; fi;)
echo selftests: bpf: test_align
(./test_align >> $OUTPUT 2>&1 && echo "ok 1..7 selftests: bpf: test_align [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..7 selftests: bpf: test_align [SKIP]"; else echo "not ok 1..7 selftests: bpf: test_align [FAIL]"; fi;)
echo selftests: bpf: test_verifier_log
(./test_verifier_log >> $OUTPUT 2>&1 && echo "ok 1..8 selftests: bpf: test_verifier_log [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..8 selftests: bpf: test_verifier_log [SKIP]"; else echo "not ok 1..8 selftests: bpf: test_verifier_log [FAIL]"; fi;)
echo selftests: bpf: test_dev_cgroup
(./test_dev_cgroup >> $OUTPUT 2>&1 && echo "ok 1..9 selftests: bpf: test_dev_cgroup [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..9 selftests: bpf: test_dev_cgroup [SKIP]"; else echo "not ok 1..9 selftests: bpf: test_dev_cgroup [FAIL]"; fi;)
echo selftests: bpf: test_tcpbpf_user
(./test_tcpbpf_user >> $OUTPUT 2>&1 && echo "ok 1..10 selftests: bpf: test_tcpbpf_user [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..10 selftests: bpf: test_tcpbpf_user [SKIP]"; else echo "not ok 1..10 selftests: bpf: test_tcpbpf_user [FAIL]"; fi;)
echo selftests: bpf: test_sock
(./test_sock >> $OUTPUT 2>&1 && echo "ok 1..11 selftests: bpf: test_sock [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..11 selftests: bpf: test_sock [SKIP]"; else echo "not ok 1..11 selftests: bpf: test_sock [FAIL]"; fi;)
echo selftests: bpf: test_btf
(./test_btf >> $OUTPUT 2>&1 && echo "ok 1..12 selftests: bpf: test_btf [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..12 selftests: bpf: test_btf [SKIP]"; else echo "not ok 1..12 selftests: bpf: test_btf [FAIL]"; fi;)
echo selftests: bpf: test_sockmap
(./test_sockmap >> $OUTPUT 2>&1 && echo "ok 1..13 selftests: bpf: test_sockmap [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..13 selftests: bpf: test_sockmap [SKIP]"; else echo "not ok 1..13 selftests: bpf: test_sockmap [FAIL]"; fi;)
echo selftests: bpf: test_lirc_mode2_user
(./test_lirc_mode2_user >> $OUTPUT 2>&1 && echo "ok 1..14 selftests: bpf: test_lirc_mode2_user [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..14 selftests: bpf: test_lirc_mode2_user [SKIP]"; else echo "not ok 1..14 selftests: bpf: test_lirc_mode2_user [FAIL]"; fi;)
echo selftests: bpf: get_cgroup_id_user
(./get_cgroup_id_user >> $OUTPUT 2>&1 && echo "ok 1..15 selftests: bpf: get_cgroup_id_user [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..15 selftests: bpf: get_cgroup_id_user [SKIP]"; else echo "not ok 1..15 selftests: bpf: get_cgroup_id_user [FAIL]"; fi;)
echo selftests: bpf: test_socket_cookie
(./test_socket_cookie >> $OUTPUT 2>&1 && echo "ok 1..16 selftests: bpf: test_socket_cookie [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..16 selftests: bpf: test_socket_cookie [SKIP]"; else echo "not ok 1..16 selftests: bpf: test_socket_cookie [FAIL]"; fi;)
echo selftests: bpf: test_cgroup_storage
(./test_cgroup_storage >> $OUTPUT 2>&1 && echo "ok 1..17 selftests: bpf: test_cgroup_storage [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..17 selftests: bpf: test_cgroup_storage [SKIP]"; else echo "not ok 1..17 selftests: bpf: test_cgroup_storage [FAIL]"; fi;)
echo selftests: bpf: test_select_reuseport
echo "selftests: bpf: test_select_reuseport: Warning: file test_select_reuseport is not executable, correct this."
echo "not ok 1..18 selftests: bpf: test_select_reuseport [FAIL]"
echo selftests: bpf: urandom_read
(./urandom_read >> $OUTPUT 2>&1 && echo "ok 1..19 selftests: bpf: urandom_read [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..19 selftests: bpf: urandom_read [SKIP]"; else echo "not ok 1..19 selftests: bpf: urandom_read [FAIL]"; fi;)
echo selftests: bpf: test_kmod.sh
(./test_kmod.sh >> $OUTPUT 2>&1 && echo "ok 1..20 selftests: bpf: test_kmod.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..20 selftests: bpf: test_kmod.sh [SKIP]"; else echo "not ok 1..20 selftests: bpf: test_kmod.sh [FAIL]"; fi;)
echo selftests: bpf: test_libbpf.sh
(./test_libbpf.sh >> $OUTPUT 2>&1 && echo "ok 1..21 selftests: bpf: test_libbpf.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..21 selftests: bpf: test_libbpf.sh [SKIP]"; else echo "not ok 1..21 selftests: bpf: test_libbpf.sh [FAIL]"; fi;)
echo selftests: bpf: test_xdp_redirect.sh
(./test_xdp_redirect.sh >> $OUTPUT 2>&1 && echo "ok 1..22 selftests: bpf: test_xdp_redirect.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..22 selftests: bpf: test_xdp_redirect.sh [SKIP]"; else echo "not ok 1..22 selftests: bpf: test_xdp_redirect.sh [FAIL]"; fi;)
echo selftests: bpf: test_xdp_meta.sh
(./test_xdp_meta.sh >> $OUTPUT 2>&1 && echo "ok 1..23 selftests: bpf: test_xdp_meta.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..23 selftests: bpf: test_xdp_meta.sh [SKIP]"; else echo "not ok 1..23 selftests: bpf: test_xdp_meta.sh [FAIL]"; fi;)
echo selftests: bpf: test_offload.py
(./test_offload.py >> $OUTPUT 2>&1 && echo "ok 1..24 selftests: bpf: test_offload.py [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..24 selftests: bpf: test_offload.py [SKIP]"; else echo "not ok 1..24 selftests: bpf: test_offload.py [FAIL]"; fi;)
echo selftests: bpf: test_sock_addr.sh
(./test_sock_addr.sh >> $OUTPUT 2>&1 && echo "ok 1..25 selftests: bpf: test_sock_addr.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..25 selftests: bpf: test_sock_addr.sh [SKIP]"; else echo "not ok 1..25 selftests: bpf: test_sock_addr.sh [FAIL]"; fi;)
echo selftests: bpf: test_tunnel.sh
(./test_tunnel.sh >> $OUTPUT 2>&1 && echo "ok 1..26 selftests: bpf: test_tunnel.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..26 selftests: bpf: test_tunnel.sh [SKIP]"; else echo "not ok 1..26 selftests: bpf: test_tunnel.sh [FAIL]"; fi;)
echo selftests: bpf: test_lwt_seg6local.sh
(./test_lwt_seg6local.sh >> $OUTPUT 2>&1 && echo "ok 1..27 selftests: bpf: test_lwt_seg6local.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..27 selftests: bpf: test_lwt_seg6local.sh [SKIP]"; else echo "not ok 1..27 selftests: bpf: test_lwt_seg6local.sh [FAIL]"; fi;)
echo selftests: bpf: test_lirc_mode2.sh
(./test_lirc_mode2.sh >> $OUTPUT 2>&1 && echo "ok 1..28 selftests: bpf: test_lirc_mode2.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..28 selftests: bpf: test_lirc_mode2.sh [SKIP]"; else echo "not ok 1..28 selftests: bpf: test_lirc_mode2.sh [FAIL]"; fi;)
echo selftests: bpf: test_skb_cgroup_id.sh
(./test_skb_cgroup_id.sh >> $OUTPUT 2>&1 && echo "ok 1..29 selftests: bpf: test_skb_cgroup_id.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..29 selftests: bpf: test_skb_cgroup_id.sh [SKIP]"; else echo "not ok 1..29 selftests: bpf: test_skb_cgroup_id.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in breakpoints
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in breakpoints" >> /dev/kmsg
cd breakpoints
echo selftests: breakpoints: step_after_suspend_test
(./step_after_suspend_test >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: breakpoints: step_after_suspend_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: breakpoints: step_after_suspend_test [SKIP]"; else echo "not ok 1..1 selftests: breakpoints: step_after_suspend_test [FAIL]"; fi;)
echo selftests: breakpoints: breakpoint_test_arm64
(./breakpoint_test_arm64 >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: breakpoints: breakpoint_test_arm64 [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: breakpoints: breakpoint_test_arm64 [SKIP]"; else echo "not ok 1..2 selftests: breakpoints: breakpoint_test_arm64 [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in capabilities
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in capabilities" >> /dev/kmsg
cd capabilities
echo selftests: capabilities: test_execve
(./test_execve >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: capabilities: test_execve [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: capabilities: test_execve [SKIP]"; else echo "not ok 1..1 selftests: capabilities: test_execve [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in cgroup
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in cgroup" >> /dev/kmsg
cd cgroup
echo selftests: cgroup: test_memcontrol
(./test_memcontrol >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: cgroup: test_memcontrol [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: cgroup: test_memcontrol [SKIP]"; else echo "not ok 1..1 selftests: cgroup: test_memcontrol [FAIL]"; fi;)
echo selftests: cgroup: test_core
(./test_core >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: cgroup: test_core [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: cgroup: test_core [SKIP]"; else echo "not ok 1..2 selftests: cgroup: test_core [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in cpufreq
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in cpufreq" >> /dev/kmsg
cd cpufreq
echo selftests: cpufreq: main.sh
(./main.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: cpufreq: main.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: cpufreq: main.sh [SKIP]"; else echo "not ok 1..1 selftests: cpufreq: main.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in cpu-hotplug
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in cpu-hotplug" >> /dev/kmsg
cd cpu-hotplug
echo selftests: cpu-hotplug: cpu-on-off-test.sh
(./cpu-on-off-test.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: cpu-hotplug: cpu-on-off-test.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: cpu-hotplug: cpu-on-off-test.sh [SKIP]"; else echo "not ok 1..1 selftests: cpu-hotplug: cpu-on-off-test.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in efivarfs
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in efivarfs" >> /dev/kmsg
cd efivarfs
echo selftests: efivarfs: efivarfs.sh
(./efivarfs.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: efivarfs: efivarfs.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: efivarfs: efivarfs.sh [SKIP]"; else echo "not ok 1..1 selftests: efivarfs: efivarfs.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in exec
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in exec" >> /dev/kmsg
cd exec
echo selftests: exec: execveat
(./execveat >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: exec: execveat [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: exec: execveat [SKIP]"; else echo "not ok 1..1 selftests: exec: execveat [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in filesystems
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in filesystems" >> /dev/kmsg
cd filesystems
echo selftests: filesystems: devpts_pts
(./devpts_pts >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: filesystems: devpts_pts [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: filesystems: devpts_pts [SKIP]"; else echo "not ok 1..1 selftests: filesystems: devpts_pts [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in firmware
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in firmware" >> /dev/kmsg
cd firmware
echo selftests: firmware: fw_run_tests.sh
(./fw_run_tests.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: firmware: fw_run_tests.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: firmware: fw_run_tests.sh [SKIP]"; else echo "not ok 1..1 selftests: firmware: fw_run_tests.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in ftrace
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in ftrace" >> /dev/kmsg
cd ftrace
echo selftests: ftrace: ftracetest
(./ftracetest >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: ftrace: ftracetest [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: ftrace: ftracetest [SKIP]"; else echo "not ok 1..1 selftests: ftrace: ftracetest [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in futex
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in futex" >> /dev/kmsg
cd futex
echo selftests: futex: run.sh
(./run.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: futex: run.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: futex: run.sh [SKIP]"; else echo "not ok 1..1 selftests: futex: run.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in gpio
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in gpio" >> /dev/kmsg
cd gpio
echo selftests: gpio: gpio-mockup.sh
(./gpio-mockup.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: gpio: gpio-mockup.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: gpio: gpio-mockup.sh [SKIP]"; else echo "not ok 1..1 selftests: gpio: gpio-mockup.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in intel_pstate
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in intel_pstate" >> /dev/kmsg
cd intel_pstate
echo selftests: intel_pstate: run.sh
(./run.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: intel_pstate: run.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: intel_pstate: run.sh [SKIP]"; else echo "not ok 1..1 selftests: intel_pstate: run.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in ipc
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in ipc" >> /dev/kmsg
cd ipc
echo selftests: ipc: msgque
(./msgque >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: ipc: msgque [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: ipc: msgque [SKIP]"; else echo "not ok 1..1 selftests: ipc: msgque [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in kcmp
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in kcmp" >> /dev/kmsg
cd kcmp
echo selftests: kcmp: kcmp_test
(./kcmp_test >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: kcmp: kcmp_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: kcmp: kcmp_test [SKIP]"; else echo "not ok 1..1 selftests: kcmp: kcmp_test [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in kvm
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in kvm" >> /dev/kmsg
cd kvm
echo selftests: kvm: platform_info_test
echo "selftests: kvm: platform_info_test: Warning: file platform_info_test is not executable, correct this."
echo "not ok 1..1 selftests: kvm: platform_info_test [FAIL]"
echo selftests: kvm: set_sregs_test
echo "selftests: kvm: set_sregs_test: Warning: file set_sregs_test is not executable, correct this."
echo "not ok 1..2 selftests: kvm: set_sregs_test [FAIL]"
echo selftests: kvm: sync_regs_test
echo "selftests: kvm: sync_regs_test: Warning: file sync_regs_test is not executable, correct this."
echo "not ok 1..3 selftests: kvm: sync_regs_test [FAIL]"
echo selftests: kvm: vmx_tsc_adjust_test
echo "selftests: kvm: vmx_tsc_adjust_test: Warning: file vmx_tsc_adjust_test is not executable, correct this."
echo "not ok 1..4 selftests: kvm: vmx_tsc_adjust_test [FAIL]"
echo selftests: kvm: cr4_cpuid_sync_test
echo "selftests: kvm: cr4_cpuid_sync_test: Warning: file cr4_cpuid_sync_test is not executable, correct this."
echo "not ok 1..5 selftests: kvm: cr4_cpuid_sync_test [FAIL]"
echo selftests: kvm: state_test
echo "selftests: kvm: state_test: Warning: file state_test is not executable, correct this."
echo "not ok 1..6 selftests: kvm: state_test [FAIL]"
echo selftests: kvm: dirty_log_test
echo "selftests: kvm: dirty_log_test: Warning: file dirty_log_test is not executable, correct this."
echo "not ok 1..7 selftests: kvm: dirty_log_test [FAIL]"
cd $ROOT
echo ; echo TAP version 13
echo Running tests in lib
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in lib" >> /dev/kmsg
cd lib
echo selftests: lib: printf.sh
(./printf.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: lib: printf.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: lib: printf.sh [SKIP]"; else echo "not ok 1..1 selftests: lib: printf.sh [FAIL]"; fi;)
echo selftests: lib: bitmap.sh
(./bitmap.sh >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: lib: bitmap.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: lib: bitmap.sh [SKIP]"; else echo "not ok 1..2 selftests: lib: bitmap.sh [FAIL]"; fi;)
echo selftests: lib: prime_numbers.sh
(./prime_numbers.sh >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: lib: prime_numbers.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: lib: prime_numbers.sh [SKIP]"; else echo "not ok 1..3 selftests: lib: prime_numbers.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in membarrier
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in membarrier" >> /dev/kmsg
cd membarrier
echo selftests: membarrier: membarrier_test
(./membarrier_test >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: membarrier: membarrier_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: membarrier: membarrier_test [SKIP]"; else echo "not ok 1..1 selftests: membarrier: membarrier_test [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in memfd
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in memfd" >> /dev/kmsg
cd memfd
echo selftests: memfd: memfd_test
(./memfd_test >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: memfd: memfd_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: memfd: memfd_test [SKIP]"; else echo "not ok 1..1 selftests: memfd: memfd_test [FAIL]"; fi;)
echo selftests: memfd: run_fuse_test.sh
(./run_fuse_test.sh >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: memfd: run_fuse_test.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: memfd: run_fuse_test.sh [SKIP]"; else echo "not ok 1..2 selftests: memfd: run_fuse_test.sh [FAIL]"; fi;)
echo selftests: memfd: run_hugetlbfs_test.sh
(./run_hugetlbfs_test.sh >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: memfd: run_hugetlbfs_test.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: memfd: run_hugetlbfs_test.sh [SKIP]"; else echo "not ok 1..3 selftests: memfd: run_hugetlbfs_test.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in memory-hotplug
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in memory-hotplug" >> /dev/kmsg
cd memory-hotplug
echo selftests: memory-hotplug: mem-on-off-test.sh
(./mem-on-off-test.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: memory-hotplug: mem-on-off-test.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: memory-hotplug: mem-on-off-test.sh [SKIP]"; else echo "not ok 1..1 selftests: memory-hotplug: mem-on-off-test.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in mount
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in mount" >> /dev/kmsg
cd mount
echo selftests: mount: run_tests.sh
(./run_tests.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: mount: run_tests.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: mount: run_tests.sh [SKIP]"; else echo "not ok 1..1 selftests: mount: run_tests.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in mqueue
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in mqueue" >> /dev/kmsg
cd mqueue
echo selftests: mqueue: mq_open_tests
(./mq_open_tests >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: mqueue: mq_open_tests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: mqueue: mq_open_tests [SKIP]"; else echo "not ok 1..1 selftests: mqueue: mq_open_tests [FAIL]"; fi;)
echo selftests: mqueue: mq_perf_tests
(./mq_perf_tests >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: mqueue: mq_perf_tests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: mqueue: mq_perf_tests [SKIP]"; else echo "not ok 1..2 selftests: mqueue: mq_perf_tests [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in net
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in net" >> /dev/kmsg
cd net
echo selftests: net: reuseport_bpf
echo "selftests: net: reuseport_bpf: Warning: file reuseport_bpf is not executable, correct this."
echo "not ok 1..1 selftests: net: reuseport_bpf [FAIL]"
echo selftests: net: reuseport_bpf_cpu
echo "selftests: net: reuseport_bpf_cpu: Warning: file reuseport_bpf_cpu is not executable, correct this."
echo "not ok 1..2 selftests: net: reuseport_bpf_cpu [FAIL]"
echo selftests: net: reuseport_bpf_numa
echo "selftests: net: reuseport_bpf_numa: Warning: file reuseport_bpf_numa is not executable, correct this."
echo "not ok 1..3 selftests: net: reuseport_bpf_numa [FAIL]"
echo selftests: net: reuseport_dualstack
echo "selftests: net: reuseport_dualstack: Warning: file reuseport_dualstack is not executable, correct this."
echo "not ok 1..4 selftests: net: reuseport_dualstack [FAIL]"
echo selftests: net: reuseaddr_conflict
echo "selftests: net: reuseaddr_conflict: Warning: file reuseaddr_conflict is not executable, correct this."
echo "not ok 1..5 selftests: net: reuseaddr_conflict [FAIL]"
echo selftests: net: tls
echo "selftests: net: tls: Warning: file tls is not executable, correct this."
echo "not ok 1..6 selftests: net: tls [FAIL]"
echo selftests: net: run_netsocktests
(./run_netsocktests >> $OUTPUT 2>&1 && echo "ok 1..7 selftests: net: run_netsocktests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..7 selftests: net: run_netsocktests [SKIP]"; else echo "not ok 1..7 selftests: net: run_netsocktests [FAIL]"; fi;)
echo selftests: net: run_afpackettests
(./run_afpackettests >> $OUTPUT 2>&1 && echo "ok 1..8 selftests: net: run_afpackettests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..8 selftests: net: run_afpackettests [SKIP]"; else echo "not ok 1..8 selftests: net: run_afpackettests [FAIL]"; fi;)
echo selftests: net: test_bpf.sh
(./test_bpf.sh >> $OUTPUT 2>&1 && echo "ok 1..9 selftests: net: test_bpf.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..9 selftests: net: test_bpf.sh [SKIP]"; else echo "not ok 1..9 selftests: net: test_bpf.sh [FAIL]"; fi;)
echo selftests: net: netdevice.sh
(./netdevice.sh >> $OUTPUT 2>&1 && echo "ok 1..10 selftests: net: netdevice.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..10 selftests: net: netdevice.sh [SKIP]"; else echo "not ok 1..10 selftests: net: netdevice.sh [FAIL]"; fi;)
echo selftests: net: rtnetlink.sh
(./rtnetlink.sh >> $OUTPUT 2>&1 && echo "ok 1..11 selftests: net: rtnetlink.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..11 selftests: net: rtnetlink.sh [SKIP]"; else echo "not ok 1..11 selftests: net: rtnetlink.sh [FAIL]"; fi;)
echo selftests: net: fib_tests.sh
(./fib_tests.sh >> $OUTPUT 2>&1 && echo "ok 1..12 selftests: net: fib_tests.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..12 selftests: net: fib_tests.sh [SKIP]"; else echo "not ok 1..12 selftests: net: fib_tests.sh [FAIL]"; fi;)
echo selftests: net: fib-onlink-tests.sh
(./fib-onlink-tests.sh >> $OUTPUT 2>&1 && echo "ok 1..13 selftests: net: fib-onlink-tests.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..13 selftests: net: fib-onlink-tests.sh [SKIP]"; else echo "not ok 1..13 selftests: net: fib-onlink-tests.sh [FAIL]"; fi;)
echo selftests: net: pmtu.sh
(./pmtu.sh >> $OUTPUT 2>&1 && echo "ok 1..14 selftests: net: pmtu.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..14 selftests: net: pmtu.sh [SKIP]"; else echo "not ok 1..14 selftests: net: pmtu.sh [FAIL]"; fi;)
echo selftests: net: udpgso.sh
(./udpgso.sh >> $OUTPUT 2>&1 && echo "ok 1..15 selftests: net: udpgso.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..15 selftests: net: udpgso.sh [SKIP]"; else echo "not ok 1..15 selftests: net: udpgso.sh [FAIL]"; fi;)
echo selftests: net: udpgso_bench.sh
(./udpgso_bench.sh >> $OUTPUT 2>&1 && echo "ok 1..16 selftests: net: udpgso_bench.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..16 selftests: net: udpgso_bench.sh [SKIP]"; else echo "not ok 1..16 selftests: net: udpgso_bench.sh [FAIL]"; fi;)
echo selftests: net: fib_rule_tests.sh
(./fib_rule_tests.sh >> $OUTPUT 2>&1 && echo "ok 1..17 selftests: net: fib_rule_tests.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..17 selftests: net: fib_rule_tests.sh [SKIP]"; else echo "not ok 1..17 selftests: net: fib_rule_tests.sh [FAIL]"; fi;)
echo selftests: net: msg_zerocopy.sh
(./msg_zerocopy.sh >> $OUTPUT 2>&1 && echo "ok 1..18 selftests: net: msg_zerocopy.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..18 selftests: net: msg_zerocopy.sh [SKIP]"; else echo "not ok 1..18 selftests: net: msg_zerocopy.sh [FAIL]"; fi;)
echo selftests: net: psock_snd.sh
(./psock_snd.sh >> $OUTPUT 2>&1 && echo "ok 1..19 selftests: net: psock_snd.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..19 selftests: net: psock_snd.sh [SKIP]"; else echo "not ok 1..19 selftests: net: psock_snd.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in netfilter
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in netfilter" >> /dev/kmsg
cd netfilter
echo selftests: netfilter: nft_trans_stress.sh
(./nft_trans_stress.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: netfilter: nft_trans_stress.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: netfilter: nft_trans_stress.sh [SKIP]"; else echo "not ok 1..1 selftests: netfilter: nft_trans_stress.sh [FAIL]"; fi;)
echo selftests: netfilter: nft_nat.sh
(./nft_nat.sh >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: netfilter: nft_nat.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: netfilter: nft_nat.sh [SKIP]"; else echo "not ok 1..2 selftests: netfilter: nft_nat.sh [FAIL]"; fi;)
echo selftests: netfilter: conntrack_icmp_related.sh
(./conntrack_icmp_related.sh >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: netfilter: conntrack_icmp_related.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: netfilter: conntrack_icmp_related.sh [SKIP]"; else echo "not ok 1..3 selftests: netfilter: conntrack_icmp_related.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in nsfs
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in nsfs" >> /dev/kmsg
cd nsfs
echo selftests: nsfs: owner
(./owner >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: nsfs: owner [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: nsfs: owner [SKIP]"; else echo "not ok 1..1 selftests: nsfs: owner [FAIL]"; fi;)
echo selftests: nsfs: pidns
(./pidns >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: nsfs: pidns [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: nsfs: pidns [SKIP]"; else echo "not ok 1..2 selftests: nsfs: pidns [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in powerpc
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in powerpc" >> /dev/kmsg
cd powerpc
cd $ROOT
echo ; echo TAP version 13
echo Running tests in proc
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in proc" >> /dev/kmsg
cd proc
echo selftests: proc: fd-001-lookup
(./fd-001-lookup >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: proc: fd-001-lookup [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: proc: fd-001-lookup [SKIP]"; else echo "not ok 1..1 selftests: proc: fd-001-lookup [FAIL]"; fi;)
echo selftests: proc: fd-002-posix-eq
(./fd-002-posix-eq >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: proc: fd-002-posix-eq [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: proc: fd-002-posix-eq [SKIP]"; else echo "not ok 1..2 selftests: proc: fd-002-posix-eq [FAIL]"; fi;)
echo selftests: proc: fd-003-kthread
(./fd-003-kthread >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: proc: fd-003-kthread [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: proc: fd-003-kthread [SKIP]"; else echo "not ok 1..3 selftests: proc: fd-003-kthread [FAIL]"; fi;)
echo selftests: proc: proc-loadavg-001
(./proc-loadavg-001 >> $OUTPUT 2>&1 && echo "ok 1..4 selftests: proc: proc-loadavg-001 [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..4 selftests: proc: proc-loadavg-001 [SKIP]"; else echo "not ok 1..4 selftests: proc: proc-loadavg-001 [FAIL]"; fi;)
echo selftests: proc: proc-self-map-files-001
(./proc-self-map-files-001 >> $OUTPUT 2>&1 && echo "ok 1..5 selftests: proc: proc-self-map-files-001 [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..5 selftests: proc: proc-self-map-files-001 [SKIP]"; else echo "not ok 1..5 selftests: proc: proc-self-map-files-001 [FAIL]"; fi;)
echo selftests: proc: proc-self-map-files-002
(./proc-self-map-files-002 >> $OUTPUT 2>&1 && echo "ok 1..6 selftests: proc: proc-self-map-files-002 [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..6 selftests: proc: proc-self-map-files-002 [SKIP]"; else echo "not ok 1..6 selftests: proc: proc-self-map-files-002 [FAIL]"; fi;)
echo selftests: proc: proc-self-syscall
(./proc-self-syscall >> $OUTPUT 2>&1 && echo "ok 1..7 selftests: proc: proc-self-syscall [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..7 selftests: proc: proc-self-syscall [SKIP]"; else echo "not ok 1..7 selftests: proc: proc-self-syscall [FAIL]"; fi;)
echo selftests: proc: proc-self-wchan
(./proc-self-wchan >> $OUTPUT 2>&1 && echo "ok 1..8 selftests: proc: proc-self-wchan [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..8 selftests: proc: proc-self-wchan [SKIP]"; else echo "not ok 1..8 selftests: proc: proc-self-wchan [FAIL]"; fi;)
echo selftests: proc: proc-uptime-001
(./proc-uptime-001 >> $OUTPUT 2>&1 && echo "ok 1..9 selftests: proc: proc-uptime-001 [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..9 selftests: proc: proc-uptime-001 [SKIP]"; else echo "not ok 1..9 selftests: proc: proc-uptime-001 [FAIL]"; fi;)
echo selftests: proc: proc-uptime-002
(./proc-uptime-002 >> $OUTPUT 2>&1 && echo "ok 1..10 selftests: proc: proc-uptime-002 [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..10 selftests: proc: proc-uptime-002 [SKIP]"; else echo "not ok 1..10 selftests: proc: proc-uptime-002 [FAIL]"; fi;)
echo selftests: proc: read
(./read >> $OUTPUT 2>&1 && echo "ok 1..11 selftests: proc: read [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..11 selftests: proc: read [SKIP]"; else echo "not ok 1..11 selftests: proc: read [FAIL]"; fi;)
echo selftests: proc: self
(./self >> $OUTPUT 2>&1 && echo "ok 1..12 selftests: proc: self [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..12 selftests: proc: self [SKIP]"; else echo "not ok 1..12 selftests: proc: self [FAIL]"; fi;)
echo selftests: proc: setns-dcache
(./setns-dcache >> $OUTPUT 2>&1 && echo "ok 1..13 selftests: proc: setns-dcache [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..13 selftests: proc: setns-dcache [SKIP]"; else echo "not ok 1..13 selftests: proc: setns-dcache [FAIL]"; fi;)
echo selftests: proc: thread-self
(./thread-self >> $OUTPUT 2>&1 && echo "ok 1..14 selftests: proc: thread-self [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..14 selftests: proc: thread-self [SKIP]"; else echo "not ok 1..14 selftests: proc: thread-self [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in pstore
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in pstore" >> /dev/kmsg
cd pstore
echo selftests: pstore: pstore_tests
(./pstore_tests >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: pstore: pstore_tests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: pstore: pstore_tests [SKIP]"; else echo "not ok 1..1 selftests: pstore: pstore_tests [FAIL]"; fi;)
echo selftests: pstore: pstore_post_reboot_tests
(./pstore_post_reboot_tests >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: pstore: pstore_post_reboot_tests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: pstore: pstore_post_reboot_tests [SKIP]"; else echo "not ok 1..2 selftests: pstore: pstore_post_reboot_tests [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in ptrace
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in ptrace" >> /dev/kmsg
cd ptrace
echo selftests: ptrace: peeksiginfo
(./peeksiginfo >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: ptrace: peeksiginfo [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: ptrace: peeksiginfo [SKIP]"; else echo "not ok 1..1 selftests: ptrace: peeksiginfo [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in rseq
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in rseq" >> /dev/kmsg
cd rseq
echo selftests: rseq: basic_test
(./basic_test >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: rseq: basic_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: rseq: basic_test [SKIP]"; else echo "not ok 1..1 selftests: rseq: basic_test [FAIL]"; fi;)
echo selftests: rseq: basic_percpu_ops_test
(./basic_percpu_ops_test >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: rseq: basic_percpu_ops_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: rseq: basic_percpu_ops_test [SKIP]"; else echo "not ok 1..2 selftests: rseq: basic_percpu_ops_test [FAIL]"; fi;)
echo selftests: rseq: param_test
(./param_test >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: rseq: param_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: rseq: param_test [SKIP]"; else echo "not ok 1..3 selftests: rseq: param_test [FAIL]"; fi;)
echo selftests: rseq: param_test_benchmark
(./param_test_benchmark >> $OUTPUT 2>&1 && echo "ok 1..4 selftests: rseq: param_test_benchmark [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..4 selftests: rseq: param_test_benchmark [SKIP]"; else echo "not ok 1..4 selftests: rseq: param_test_benchmark [FAIL]"; fi;)
echo selftests: rseq: param_test_compare_twice
(./param_test_compare_twice >> $OUTPUT 2>&1 && echo "ok 1..5 selftests: rseq: param_test_compare_twice [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..5 selftests: rseq: param_test_compare_twice [SKIP]"; else echo "not ok 1..5 selftests: rseq: param_test_compare_twice [FAIL]"; fi;)
echo selftests: rseq: run_param_test.sh
(./run_param_test.sh >> $OUTPUT 2>&1 && echo "ok 1..6 selftests: rseq: run_param_test.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..6 selftests: rseq: run_param_test.sh [SKIP]"; else echo "not ok 1..6 selftests: rseq: run_param_test.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in rtc
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in rtc" >> /dev/kmsg
cd rtc
echo selftests: rtc: rtctest
(./rtctest >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: rtc: rtctest [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: rtc: rtctest [SKIP]"; else echo "not ok 1..1 selftests: rtc: rtctest [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in seccomp
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in seccomp" >> /dev/kmsg
cd seccomp
echo selftests: seccomp: seccomp_bpf
(./seccomp_bpf >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: seccomp: seccomp_bpf [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: seccomp: seccomp_bpf [SKIP]"; else echo "not ok 1..1 selftests: seccomp: seccomp_bpf [FAIL]"; fi;)
echo selftests: seccomp: seccomp_benchmark
(./seccomp_benchmark >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: seccomp: seccomp_benchmark [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: seccomp: seccomp_benchmark [SKIP]"; else echo "not ok 1..2 selftests: seccomp: seccomp_benchmark [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in sigaltstack
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in sigaltstack" >> /dev/kmsg
cd sigaltstack
echo selftests: sigaltstack: sas
(./sas >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: sigaltstack: sas [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: sigaltstack: sas [SKIP]"; else echo "not ok 1..1 selftests: sigaltstack: sas [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in size
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in size" >> /dev/kmsg
cd size
echo selftests: size: get_size
echo "selftests: size: get_size: Warning: file get_size is not executable, correct this."
echo "not ok 1..1 selftests: size: get_size [FAIL]"
cd $ROOT
echo ; echo TAP version 13
echo Running tests in sparc64
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in sparc64" >> /dev/kmsg
cd sparc64
cd $ROOT
echo ; echo TAP version 13
echo Running tests in splice
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in splice" >> /dev/kmsg
cd splice
echo selftests: splice: default_file_splice_read.sh
(./default_file_splice_read.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: splice: default_file_splice_read.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: splice: default_file_splice_read.sh [SKIP]"; else echo "not ok 1..1 selftests: splice: default_file_splice_read.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in static_keys
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in static_keys" >> /dev/kmsg
cd static_keys
echo selftests: static_keys: test_static_keys.sh
(./test_static_keys.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: static_keys: test_static_keys.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: static_keys: test_static_keys.sh [SKIP]"; else echo "not ok 1..1 selftests: static_keys: test_static_keys.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in sync
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in sync" >> /dev/kmsg
cd sync
echo selftests: sync: sync_test
(./sync_test >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: sync: sync_test [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: sync: sync_test [SKIP]"; else echo "not ok 1..1 selftests: sync: sync_test [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in sysctl
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in sysctl" >> /dev/kmsg
cd sysctl
echo selftests: sysctl: sysctl.sh
(./sysctl.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: sysctl: sysctl.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: sysctl: sysctl.sh [SKIP]"; else echo "not ok 1..1 selftests: sysctl: sysctl.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in timers
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in timers" >> /dev/kmsg
cd timers
echo selftests: timers: posix_timers
(./posix_timers >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: timers: posix_timers [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: timers: posix_timers [SKIP]"; else echo "not ok 1..1 selftests: timers: posix_timers [FAIL]"; fi;)
echo selftests: timers: nanosleep
(./nanosleep >> $OUTPUT 2>&1 && echo "ok 1..2 selftests: timers: nanosleep [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..2 selftests: timers: nanosleep [SKIP]"; else echo "not ok 1..2 selftests: timers: nanosleep [FAIL]"; fi;)
echo selftests: timers: nsleep-lat
(./nsleep-lat >> $OUTPUT 2>&1 && echo "ok 1..3 selftests: timers: nsleep-lat [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..3 selftests: timers: nsleep-lat [SKIP]"; else echo "not ok 1..3 selftests: timers: nsleep-lat [FAIL]"; fi;)
echo selftests: timers: set-timer-lat
(./set-timer-lat >> $OUTPUT 2>&1 && echo "ok 1..4 selftests: timers: set-timer-lat [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..4 selftests: timers: set-timer-lat [SKIP]"; else echo "not ok 1..4 selftests: timers: set-timer-lat [FAIL]"; fi;)
echo selftests: timers: mqueue-lat
(./mqueue-lat >> $OUTPUT 2>&1 && echo "ok 1..5 selftests: timers: mqueue-lat [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..5 selftests: timers: mqueue-lat [SKIP]"; else echo "not ok 1..5 selftests: timers: mqueue-lat [FAIL]"; fi;)
echo selftests: timers: inconsistency-check
(./inconsistency-check >> $OUTPUT 2>&1 && echo "ok 1..6 selftests: timers: inconsistency-check [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..6 selftests: timers: inconsistency-check [SKIP]"; else echo "not ok 1..6 selftests: timers: inconsistency-check [FAIL]"; fi;)
echo selftests: timers: raw_skew
(./raw_skew >> $OUTPUT 2>&1 && echo "ok 1..7 selftests: timers: raw_skew [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..7 selftests: timers: raw_skew [SKIP]"; else echo "not ok 1..7 selftests: timers: raw_skew [FAIL]"; fi;)
echo selftests: timers: threadtest
(./threadtest >> $OUTPUT 2>&1 && echo "ok 1..8 selftests: timers: threadtest [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..8 selftests: timers: threadtest [SKIP]"; else echo "not ok 1..8 selftests: timers: threadtest [FAIL]"; fi;)
echo selftests: timers: rtcpie
(./rtcpie >> $OUTPUT 2>&1 && echo "ok 1..9 selftests: timers: rtcpie [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..9 selftests: timers: rtcpie [SKIP]"; else echo "not ok 1..9 selftests: timers: rtcpie [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in user
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in user" >> /dev/kmsg
cd user
echo selftests: user: test_user_copy.sh
(./test_user_copy.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: user: test_user_copy.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: user: test_user_copy.sh [SKIP]"; else echo "not ok 1..1 selftests: user: test_user_copy.sh [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in vm
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in vm" >> /dev/kmsg
cd vm
echo selftests: vm: run_vmtests
(./run_vmtests >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: vm: run_vmtests [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: vm: run_vmtests [SKIP]"; else echo "not ok 1..1 selftests: vm: run_vmtests [FAIL]"; fi;)
cd $ROOT
echo ; echo TAP version 13
echo Running tests in x86
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in x86" >> /dev/kmsg
cd x86
cd $ROOT
echo ; echo TAP version 13
echo Running tests in zram
echo ========================================
[ -w /dev/kmsg ] && echo "kselftest: Running tests in zram" >> /dev/kmsg
cd zram
echo selftests: zram: zram.sh
(./zram.sh >> $OUTPUT 2>&1 && echo "ok 1..1 selftests: zram: zram.sh [PASS]") || (if [ $? -eq $skip ]; then echo "not ok 1..1 selftests: zram: zram.sh [SKIP]"; else echo "not ok 1..1 selftests: zram: zram.sh [FAIL]"; fi;)
cd $ROOT
