SET(TRIPLE mipsel-elvees-elf)
SET(CMAKE_TOOLCHAIN_SYSTEM_NAME Generic)
SET(CMAKE_TOOLCHAIN_SYSTEM_PROCESSOR mips32)
SET(CMAKE_TOOLCHAIN_SYSTEM_TARGET ${TRIPLE})

set_property(GLOBAL PROPERTY TARGET_SUPPORTS_SHARED_LIBS FALSE)

SET(CMAKE_SYSTEM_NAME      ${CMAKE_TOOLCHAIN_SYSTEM_NAME})
SET(CMAKE_SYSTEM_PROCESSOR ${CMAKE_TOOLCHAIN_SYSTEM_PROCESSOR})
SET(CMAKE_SYSTEM_TARGET    ${CMAKE_TOOLCHAIN_SYSTEM_TARGET})

SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)

if(WIN32)
  SET(EXECUTABLE_SUFFIX ".exe")
else()
  SET(EXECUTABLE_SUFFIX "")
endif()

set(CMAKE_C_FLAGS_INIT "$ENV{CFLAGS} ${CMAKE_C_FLAGS_INIT}")
# avoid just having a space as the initial value for the cache
if(CMAKE_C_FLAGS_INIT STREQUAL " ")
  set(CMAKE_C_FLAGS_INIT)
endif()
set(CMAKE_C_FLAGS "-mcom03-errata -Wa,-mcom03-errata -Wa,-mfix-mc24r2" CACHE STRING "Flags used by the compiler during all build types" FORCE)
set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} 	 ${CMAKE_SOURCE_DIR}/mcom03_mips.xl")

SET(CMAKE_C_COMPILER   "${TRIPLE}-gcc${EXECUTABLE_SUFFIX}")
SET(CMAKE_CXX_COMPILER "${TRIPLE}-g++${EXECUTABLE_SUFFIX}")
SET(CMAKE_ASM_COMPILER "${TRIPLE}-gcc${EXECUTABLE_SUFFIX}")
