# Copyright 2019 RnD Center "ELVEES", JSC
# This toolchain file assumes that ELcore-50 toolchain is either added to PATH
# or located in elcore_toolchain_prefix/share/cmake/elcore50-toolchain.cmake

set(CMAKE_SYSTEM_NAME      Generic)
set(CMAKE_SYSTEM_PROCESSOR elcore50)
set(CMAKE_SYSTEM_TARGET    elcore-elvis-elf)

set_property(GLOBAL PROPERTY TARGET_SUPPORTS_SHARED_LIBS FALSE)

set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)
set(CMAKE_FIND_ROOT_PATH_MODE_PACKAGE ONLY)

# CMAKE_<lang>_COMPILER_TARGET variables are not defined, because
# - it should be set to elcore32, which is useless for user;
# - default target for the toolchain is elcore32, so it can be omitted.
# For the same reasons --target and -Wa options are not included in CMAKE_<lang>_FLAGS.

if(EXISTS ${CMAKE_CURRENT_LIST_DIR}/../../bin/${CMAKE_SYSTEM_TARGET}-as)
    set(elcore_toolchain_prefix ${CMAKE_CURRENT_LIST_DIR}/../../)
    get_filename_component(elcore_toolchain_prefix ${elcore_toolchain_prefix} ABSOLUTE)
else()
    find_program(elcore_toolchain_prefix ${CMAKE_SYSTEM_TARGET}-as)
    get_filename_component(elcore_toolchain_prefix ${elcore_toolchain_prefix} DIRECTORY)
    set(elcore_toolchain_prefix ${elcore_toolchain_prefix}/..)
    get_filename_component(elcore_toolchain_prefix ${elcore_toolchain_prefix} ABSOLUTE)
endif()

set(CMAKE_SYSROOT ${elcore_toolchain_prefix}/${CMAKE_SYSTEM_TARGET})

set(CMAKE_C_COMPILER ${elcore_toolchain_prefix}/bin/clang)
set(CMAKE_CXX_COMPILER ${elcore_toolchain_prefix}/bin/clang++)

# If BUILD_TYPE=Release in buildroot, cmake variable
# CMAKE_<LANG>_FLAGS_RELEASE is inserted to the end of the
# clang call command. This may cause the optimization flags
# -On specified by the DSP programmer to be overwritten.
set(CMAKE_C_FLAGS_RELEASE "")
set(CMAKE_CXX_FLAGS_RELEASE "")

set(CMAKE_C_COMPILER_EXTERNAL_TOOLCHAIN ${CMAKE_SYSROOT})
set(CMAKE_CXX_COMPILER_EXTERNAL_TOOLCHAIN ${CMAKE_SYSROOT})

# Suppress unused-command-line-argument warnings. They make a lot of noise.
set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -Wno-unused-command-line-argument")
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -Wno-unused-command-line-argument")
set(CMAKE_ASM_FLAGS "${CMAKE_ASM_FLAGS} -Wno-unused-command-line-argument")

unset(elcore_toolchain_prefix)
