/*===---- elcore32intrin.h - Elcore32 intrinsics ----------------------------===
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef __ELCORE32INTRIN_H
#define __ELCORE32INTRIN_H

#if defined(__cplusplus)
extern "C" {
#endif

#include <stdint.h>
_Static_assert(sizeof(double) == 8);
_Static_assert(sizeof(float) == 4);

/* scalar types */

/* predicate of vectors */

typedef int8_t pred_t;

/* EVX types */

/* 512 bits */

typedef
__attribute__((__vector_size__(8 * sizeof(int64_t)))) int64_t
v8i64_t;

typedef
__attribute__((__vector_size__(8 * sizeof(double)))) double
v8f64_t;

typedef
__attribute__((__vector_size__(16 * sizeof(int32_t)))) int32_t
v16i32_t;

typedef
__attribute__((__vector_size__(16 * sizeof(float)))) float
v16f32_t;

typedef
__attribute__((__vector_size__(32 * sizeof(int16_t)))) int16_t
v32i16_t;

typedef
__attribute__((__vector_size__(64 * sizeof(int8_t)))) int8_t
v64i8_t;

/* 1024 bits */

typedef
__attribute__((__vector_size__(16 * sizeof(int64_t)))) int64_t
v16i64_t;

typedef
__attribute__((__vector_size__(16 * sizeof(double)))) double
v16f64_t;

typedef
__attribute__((__vector_size__(32 * sizeof(int32_t)))) int32_t
v32i32_t;

typedef
__attribute__((__vector_size__(32 * sizeof(float)))) float
v32f32_t;

typedef
__attribute__((__vector_size__(64 * sizeof(int16_t)))) int16_t
v64i16_t;

typedef
__attribute__((__vector_size__(128 * sizeof(int8_t)))) int8_t
v128i8_t;

/* predicate of vectors */

typedef int64_t vp_t;

/* Define the default attributes for the functions in this file. */
#define __DEFAULT_FN_ATTRS __attribute__((__always_inline__, __nodebug__))

/* scalar intrinsics */

static __inline__ void __DEFAULT_FN_ATTRS
__nop()
{
  return __builtin_elcore32_nop();
}

// This code is autogenerated by create-builtins-patch.py, do not edit!
// Maintainers: pkolomytsev, dtroshkov.

// create-builtins-patch.py create_scalar_header

static __inline__ int64_t __DEFAULT_FN_ATTRS
__absd(
  int64_t s
)
{
  return __builtin_elcore32_absd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__absd_sat(
  int64_t s
)
{
  return __builtin_elcore32_absd_sat(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__absl(
  int32_t s
)
{
  return __builtin_elcore32_absl(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__absl_sat(
  int32_t s
)
{
  return __builtin_elcore32_absl_sat(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addaddl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_addaddl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addaddl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addaddl_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addasrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_addasrl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__addd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_addd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__addd_sat(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_addd_sat(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__addd_scl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_addd_scl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__addd_scl_rnd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_addd_scl_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addl_rnd(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addl_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addl_sat(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addl_sat(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addl_scl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addl_scl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addl_scl_rnd(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addl_scl_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addlsll(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_addlsll(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__addlsrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_addlsrl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__addsubl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_addsubl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__addxl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_addxl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andandcl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andandcl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andandl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andandl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andasrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andasrl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__andcd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_andcd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andcl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_andcl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__andd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_andd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andeorl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andeorl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__andid(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_andid(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andil(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_andil(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_andl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andlsll(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andlsll(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andlsrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andlsrl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__andorl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_andorl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__asrd(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_asrd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__asrd1(
  const uint8_t s1, int64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_asrd1(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__asrl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_asrl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__bitclrl_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_bitclrl_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__biteorl_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_biteorl_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__bitsetl_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_bitsetl_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__brevd(
  int64_t s
)
{
  return __builtin_elcore32_brevd(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__brevl(
  int32_t s
)
{
  return __builtin_elcore32_brevl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__cchinv(
  const uint16_t s1, const uint32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 65535) && (0 <= s2 && s2 <= 4294967295),
            "s1 must be IMM: [0...65535], s2 must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_cchinv(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__cchinvr(
  const uint16_t s1, int32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 65535),
            "s1 must be IMM: [0...65535]")
))
{
  return __builtin_elcore32_cchinvr(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__cchpf(
  int32_t s
)
{
  return __builtin_elcore32_cchpf(s);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__chkeqv(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_chkeqv(s);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__chkev(
  int32_t s
)
{
  return __builtin_elcore32_chkev(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__clbd(
  int64_t s
)
{
  return __builtin_elcore32_clbd(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__clbl(
  int32_t s
)
{
  return __builtin_elcore32_clbl(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__clipl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_clipl_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__clod(
  int64_t s
)
{
  return __builtin_elcore32_clod(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__clol(
  int32_t s
)
{
  return __builtin_elcore32_clol(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__clrd_def(
  int64_t def
)
{
  return __builtin_elcore32_clrd_def(def);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__clzd(
  int64_t s
)
{
  return __builtin_elcore32_clzd(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__clzl(
  int32_t s
)
{
  return __builtin_elcore32_clzl(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ctod(
  int64_t s
)
{
  return __builtin_elcore32_ctod(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ctol(
  int32_t s
)
{
  return __builtin_elcore32_ctol(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ctzd(
  int64_t s
)
{
  return __builtin_elcore32_ctzd(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ctzl(
  int32_t s
)
{
  return __builtin_elcore32_ctzl(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvbd(
  int8_t s
)
{
  return __builtin_elcore32_cvbd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvbdu(
  int8_t s
)
{
  return __builtin_elcore32_cvbdu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvbl(
  int8_t s
)
{
  return __builtin_elcore32_cvbl(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvblu(
  int8_t s
)
{
  return __builtin_elcore32_cvblu(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdb(
  int64_t s
)
{
  return __builtin_elcore32_cvdb(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdb_sat(
  int64_t s
)
{
  return __builtin_elcore32_cvdb_sat(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdbu_sat(
  int64_t s
)
{
  return __builtin_elcore32_cvdbu_sat(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__cvdd(
  int64_t s
)
{
  return __builtin_elcore32_cvdd(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__cvddu(
  int64_t s
)
{
  return __builtin_elcore32_cvddu(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvdf(
  int64_t s
)
{
  return __builtin_elcore32_cvdf(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvdfu(
  int64_t s
)
{
  return __builtin_elcore32_cvdfu(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdh(
  int64_t s
)
{
  return __builtin_elcore32_cvdh(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdh_sat(
  int64_t s
)
{
  return __builtin_elcore32_cvdh_sat(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdhu_sat(
  int64_t s
)
{
  return __builtin_elcore32_cvdhu_sat(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdl(
  int64_t s
)
{
  return __builtin_elcore32_cvdl(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdl_sat(
  int64_t s
)
{
  return __builtin_elcore32_cvdl_sat(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvdlu_sat(
  int64_t s
)
{
  return __builtin_elcore32_cvdlu_sat(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvhd(
  int16_t s
)
{
  return __builtin_elcore32_cvhd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvhdu(
  int16_t s
)
{
  return __builtin_elcore32_cvhdu(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvhf(
  int16_t s
)
{
  return __builtin_elcore32_cvhf(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvhfu(
  int16_t s
)
{
  return __builtin_elcore32_cvhfu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvhl(
  int16_t s
)
{
  return __builtin_elcore32_cvhl(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvhlu(
  int16_t s
)
{
  return __builtin_elcore32_cvhlu(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__cvid(
  int32_t s
)
{
  return __builtin_elcore32_cvid(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__cvidu(
  int32_t s
)
{
  return __builtin_elcore32_cvidu(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvif(
  int32_t s
)
{
  return __builtin_elcore32_cvif(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvifu(
  int32_t s
)
{
  return __builtin_elcore32_cvifu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvlb(
  int32_t s
)
{
  return __builtin_elcore32_cvlb(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvlb_sat(
  int32_t s
)
{
  return __builtin_elcore32_cvlb_sat(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvlbu_sat(
  int32_t s
)
{
  return __builtin_elcore32_cvlbu_sat(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvld(
  int32_t s
)
{
  return __builtin_elcore32_cvld(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__cvldu(
  int32_t s
)
{
  return __builtin_elcore32_cvldu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvlh(
  int32_t s
)
{
  return __builtin_elcore32_cvlh(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvlh_sat(
  int32_t s
)
{
  return __builtin_elcore32_cvlh_sat(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__cvlhu_sat(
  int32_t s
)
{
  return __builtin_elcore32_cvlhu_sat(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__cvrf(
  const uint8_t s1, int32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_cvrf(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dadd(
  double s1, double s2
)
{
  return __builtin_elcore32_dadd(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__dbbreak(
  const uint16_t s
) __attribute__((
  enable_if((0 <= s && s <= 65535),
            "s must be IMM: [0...65535]")
))
{
  return __builtin_elcore32_dbbreak(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dceil(
  double s
)
{
  return __builtin_elcore32_dceil(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__dclass(
  double s
)
{
  return __builtin_elcore32_dclass(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvd(
  double s
)
{
  return __builtin_elcore32_dcvd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvd_ceil(
  double s
)
{
  return __builtin_elcore32_dcvd_ceil(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvd_floor(
  double s
)
{
  return __builtin_elcore32_dcvd_floor(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvd_round(
  double s
)
{
  return __builtin_elcore32_dcvd_round(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvd_trunc(
  double s
)
{
  return __builtin_elcore32_dcvd_trunc(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvdu(
  double s
)
{
  return __builtin_elcore32_dcvdu(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvdu_ceil(
  double s
)
{
  return __builtin_elcore32_dcvdu_ceil(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvdu_floor(
  double s
)
{
  return __builtin_elcore32_dcvdu_floor(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvdu_round(
  double s
)
{
  return __builtin_elcore32_dcvdu_round(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__dcvdu_trunc(
  double s
)
{
  return __builtin_elcore32_dcvdu_trunc(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__dcvi(
  double s
)
{
  return __builtin_elcore32_dcvi(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__dcviu(
  double s
)
{
  return __builtin_elcore32_dcviu(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__dfcv(
  double s
)
{
  return __builtin_elcore32_dfcv(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dfloor(
  double s
)
{
  return __builtin_elcore32_dfloor(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__dhcv(
  double s
)
{
  return __builtin_elcore32_dhcv(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__divl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_divl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__divlu(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_divlu(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__divreml(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_divreml(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__divremlu(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_divremlu(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dmax(
  double s1, double s2
)
{
  return __builtin_elcore32_dmax(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dmin(
  double s1, double s2
)
{
  return __builtin_elcore32_dmin(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dmpy(
  double s1, double s2
)
{
  return __builtin_elcore32_dmpy(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__drec0(
  double s
)
{
  return __builtin_elcore32_drec0(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__drec1(
  double s1, double s2
)
{
  return __builtin_elcore32_drec1(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__drecr0(
  double s
)
{
  return __builtin_elcore32_drecr0(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__drecr1(
  double s1, double s2
)
{
  return __builtin_elcore32_drecr1(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dround(
  double s
)
{
  return __builtin_elcore32_dround(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dsub(
  double s1, double s2
)
{
  return __builtin_elcore32_dsub(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__dtrunc(
  double s
)
{
  return __builtin_elcore32_dtrunc(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eorandcl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eorandcl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eorandl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eorandl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eorasrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eorasrl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__eord(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_eord(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eoreorl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eoreorl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eorl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_eorl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eorlsll(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eorlsll(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eorlsrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eorlsrl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__eororl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_eororl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ext(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_ext(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__extb(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_extb(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__extbu(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_extbu(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__exth(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_exth(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__exthu(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_exthu(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__extrl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_extrl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__extrls(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_extrls(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__exts(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_exts(s1, s2, s3);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fadd(
  float s1, float s2
)
{
  return __builtin_elcore32_fadd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fas(
  float s1, float s2
)
{
  return __builtin_elcore32_fas(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__fatan(
  float s1, float s2
)
{
  return __builtin_elcore32_fatan(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__fatan1(
  float s
)
{
  return __builtin_elcore32_fatan1(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fatan2(
  float s1, float s2
)
{
  return __builtin_elcore32_fatan2(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__fatanl(
  float s1, float s2
)
{
  return __builtin_elcore32_fatanl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fax(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_fax(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fceil(
  float s
)
{
  return __builtin_elcore32_fceil(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fclass(
  float s
)
{
  return __builtin_elcore32_fclass(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fcospi(
  int32_t s
)
{
  return __builtin_elcore32_fcospi(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcospil(
  int32_t s
)
{
  return __builtin_elcore32_fcospil(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fcvd(
  float s
)
{
  return __builtin_elcore32_fcvd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fcvdu(
  float s
)
{
  return __builtin_elcore32_fcvdu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvh(
  float s
)
{
  return __builtin_elcore32_fcvh(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvhu(
  float s
)
{
  return __builtin_elcore32_fcvhu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvi(
  float s
)
{
  return __builtin_elcore32_fcvi(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvi_ceil(
  float s
)
{
  return __builtin_elcore32_fcvi_ceil(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvi_floor(
  float s
)
{
  return __builtin_elcore32_fcvi_floor(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvi_round(
  float s
)
{
  return __builtin_elcore32_fcvi_round(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvi_trunc(
  float s
)
{
  return __builtin_elcore32_fcvi_trunc(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcviu(
  float s
)
{
  return __builtin_elcore32_fcviu(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcviu_ceil(
  float s
)
{
  return __builtin_elcore32_fcviu_ceil(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcviu_floor(
  float s
)
{
  return __builtin_elcore32_fcviu_floor(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcviu_round(
  float s
)
{
  return __builtin_elcore32_fcviu_round(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcviu_trunc(
  float s
)
{
  return __builtin_elcore32_fcviu_trunc(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fcvr(
  const uint8_t s1, float s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_fcvr(s1, s2);
}

static __inline__ double __DEFAULT_FN_ATTRS
__fdcv(
  float s
)
{
  return __builtin_elcore32_fdcv(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fdiv(
  float s1, float s2
)
{
  return __builtin_elcore32_fdiv(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fexp2(
  float s
)
{
  return __builtin_elcore32_fexp2(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__ffloor(
  float s
)
{
  return __builtin_elcore32_ffloor(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fhcv(
  float s
)
{
  return __builtin_elcore32_fhcv(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fisqrt(
  float s
)
{
  return __builtin_elcore32_fisqrt(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__flog(
  float s
)
{
  return __builtin_elcore32_flog(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fmadd(
  float s1, float s2, float s3
)
{
  return __builtin_elcore32_fmadd(s1, s2, s3);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fmadd_def(
  float def, float s1, float s2
)
{
  return __builtin_elcore32_fmadd_def(def, s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fmax(
  float s1, float s2
)
{
  return __builtin_elcore32_fmax(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fmin(
  float s1, float s2
)
{
  return __builtin_elcore32_fmin(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fmpy(
  float s1, float s2
)
{
  return __builtin_elcore32_fmpy(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fmsub_def(
  float def, float s1, float s2
)
{
  return __builtin_elcore32_fmsub_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fmx(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_fmx(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fmxj(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_fmxj(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__frecip(
  float s
)
{
  return __builtin_elcore32_frecip(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fround(
  float s
)
{
  return __builtin_elcore32_fround(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fsa(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_fsa(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fsaj(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_fsaj(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fsinpi(
  int32_t s
)
{
  return __builtin_elcore32_fsinpi(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__fsinpil(
  int32_t s
)
{
  return __builtin_elcore32_fsinpil(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fsqrt(
  float s
)
{
  return __builtin_elcore32_fsqrt(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__fsub(
  float s1, float s2
)
{
  return __builtin_elcore32_fsub(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__fsx(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_fsx(s1, s2);
}

static __inline__ float __DEFAULT_FN_ATTRS
__ftrunc(
  float s
)
{
  return __builtin_elcore32_ftrunc(s);
}

static __inline__ double __DEFAULT_FN_ATTRS
__hdcv(
  int16_t s
)
{
  return __builtin_elcore32_hdcv(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
__hfcv(
  int16_t s
)
{
  return __builtin_elcore32_hfcv(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ins_def(
  int32_t def, int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_ins_def(def, s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__insd_def(
  int64_t def, int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_insd_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__insl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_insl_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__insrl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_insrl_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldeqv(
  
)
{
  return __builtin_elcore32_ldeqv();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldev(
  
)
{
  return __builtin_elcore32_ldev();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl(
  void * addr
)
{
  return __builtin_elcore32_ldl(addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_add_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_add_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_add_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_add_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_add_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_add_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_add_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_add_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_add_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_add_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_and_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_and_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_and_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_and_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_and_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_and_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_and_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_and_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_and_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_and_e32_def(def, imm_addr);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ldl_a_cmpxch_ami_def(
  int64_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_cmpxch_ami_def(def, addr, offset);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ldl_a_cmpxch_api_def(
  int64_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_cmpxch_api_def(def, addr, offset);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ldl_a_cmpxch_appi_def(
  int64_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_cmpxch_appi_def(def, addr, offset);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ldl_a_cmpxch_def(
  int64_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_cmpxch_def(def, addr);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ldl_a_cmpxch_e32_def(
  int64_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_cmpxch_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_dec(
  void * addr
)
{
  return __builtin_elcore32_ldl_a_dec(addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_dec_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_dec_ami(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_dec_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_dec_api(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_dec_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_dec_appi(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_dec_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_dec_e32(imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_eor_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_eor_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_eor_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_eor_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_eor_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_eor_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_eor_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_eor_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_eor_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_eor_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_inc(
  void * addr
)
{
  return __builtin_elcore32_ldl_a_inc(addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_inc_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_inc_ami(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_inc_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_inc_api(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_inc_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_inc_appi(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_inc_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_inc_e32(imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_max_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_max_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_max_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_max_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_max_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_max_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_max_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_max_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_max_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_max_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_maxu_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_maxu_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_maxu_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_maxu_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_maxu_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_maxu_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_maxu_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_maxu_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_maxu_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_maxu_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_min_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_min_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_min_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_min_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_min_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_min_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_min_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_min_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_min_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_min_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_minu_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_minu_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_minu_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_minu_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_minu_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_minu_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_minu_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_minu_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_minu_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_minu_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_or_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_or_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_or_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_or_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_or_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_or_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_or_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_or_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_or_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_or_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_sub_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_sub_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_sub_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_sub_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_sub_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_sub_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_sub_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_sub_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_sub_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_sub_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_xch_ami_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_xch_ami_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_xch_api_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_xch_api_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_xch_appi_def(
  int32_t def, void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_a_xch_appi_def(def, addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_xch_def(
  int32_t def, void * addr
)
{
  return __builtin_elcore32_ldl_a_xch_def(def, addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_a_xch_e32_def(
  int32_t def, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_a_xch_e32_def(def, imm_addr);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_ami(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_api(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_ldl_appi(addr, offset);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ldl_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_ldl_e32(imm_addr);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__lsld(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_lsld(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__lsld1(
  const uint8_t s1, int64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_lsld1(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__lsld1_sat(
  const uint8_t s1, int64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_lsld1_sat(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__lsld_sat(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_lsld_sat(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__lsll(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_lsll(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__lsll_sat(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_lsll_sat(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__lsrd(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_lsrd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__lsrd1(
  const uint8_t s1, int64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_lsrd1(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__lsrl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_lsrl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__maddl(
  int32_t s1, int32_t s2, int64_t s3
)
{
  return __builtin_elcore32_maddl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__maddl_def(
  int64_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_maddl_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__maddllo(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_maddllo(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__maddllo_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_maddllo_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__maddlu_def(
  int64_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_maddlu_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__maxd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_maxd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__maxdu(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_maxdu(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__maxl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_maxl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__maxlu(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_maxlu(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__maxmd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_maxmd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__maxml(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_maxml(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__mbar(
  const uint16_t s
) __attribute__((
  enable_if((0 <= s && s <= 65535),
            "s must be IMM: [0...65535]")
))
{
  return __builtin_elcore32_mbar(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mfxjl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mfxjl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mfxl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mfxl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mind(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mind(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mindu(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mindu(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__minl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_minl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__minlu(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_minlu(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__minmd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_minmd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__minml(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_minml(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mpfl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpfl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpxjl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mpxjl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpxl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mpxl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpydhi(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mpydhi(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpydlo(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mpydlo(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpyduhi(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mpyduhi(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpydulo(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_mpydulo(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpyl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpyl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mpylhi(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpylhi(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mpylhi_rnd(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpylhi_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mpyllo(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpyllo(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mpylu(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpylu(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mpyluhi(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpyluhi(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mpylulo(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mpylulo(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mskbd(
  int32_t s
)
{
  return __builtin_elcore32_mskbd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mskgd(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_mskgd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__mskgdb(
  int32_t s
)
{
  return __builtin_elcore32_mskgdb(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__mskgl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_mskgl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__msubl_def(
  int64_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_msubl_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__msublu_def(
  int64_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_msublu_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__negd(
  int64_t s
)
{
  return __builtin_elcore32_negd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__negd_sat(
  int64_t s
)
{
  return __builtin_elcore32_negd_sat(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__negl(
  int32_t s
)
{
  return __builtin_elcore32_negl(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__negl_sat(
  int32_t s
)
{
  return __builtin_elcore32_negl_sat(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__notl(
  int32_t s
)
{
  return __builtin_elcore32_notl(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orandcl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_orandcl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orandl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_orandl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orasrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_orasrl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__orcd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_orcd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orcl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_orcl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ord(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_ord(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__oreorl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_oreorl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__orid(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_orid(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__oril(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_oril(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_orl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orlsll(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_orlsll(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__orlsrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_orlsrl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ororl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_ororl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__packd(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_packd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__packdhi(
  const uint32_t s1, int32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 4294967295),
            "s1 must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_packdhi(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__packdlo(
  const uint32_t s1, int32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 4294967295),
            "s1 must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_packdlo(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packhhihi(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_packhhihi(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packhhilo(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_packhhilo(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packhlohi(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_packhlohi(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packhlolo(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_packhlolo(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packlhihi(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_packlhihi(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packlhilo(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_packlhilo(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packllohi(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_packllohi(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__packllolo(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_packllolo(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pand(
  pred_t s1, pred_t s2
)
{
  return __builtin_elcore32_pand(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pandand(
  pred_t s1, pred_t s2, pred_t s3
)
{
  return __builtin_elcore32_pandand(s1, s2, s3);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pandb(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pandb(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pandd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pandd(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pandh(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pandh(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pandl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pandl(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pandor(
  pred_t s1, pred_t s2, pred_t s3
)
{
  return __builtin_elcore32_pandor(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pbitsetd1_def(
  int64_t def, const uint8_t s1, pred_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_pbitsetd1_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pbitsetd_def(
  int64_t def, int32_t s1, pred_t s2
)
{
  return __builtin_elcore32_pbitsetd_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__pbitsetl_def(
  int32_t def, int32_t s1, pred_t s2
)
{
  return __builtin_elcore32_pbitsetl_def(def, s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pbittstd(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_pbittstd(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pbittstd1(
  const uint8_t s1, int64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_pbittstd1(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pbittstl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pbittstl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_eql(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_eql(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_eql_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_eql_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_ge_m(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_ge_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_ge_m_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_ge_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_ge_s(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_ge_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_ge_s_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_ge_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_ge_u(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_ge_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_ge_u_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_ge_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_gt_m(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_gt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_gt_m_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_gt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_gt_s(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_gt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_gt_s_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_gt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_gt_u(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_gt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_gt_u_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_gt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_le_m(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_le_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_le_m_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_le_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_le_s(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_le_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_le_s_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_le_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_le_u(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_le_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_le_u_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_le_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_lt_m(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_lt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_lt_m_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_lt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_lt_s(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_lt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_lt_s_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_lt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_lt_u(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_lt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_lt_u_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_lt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpb_neq(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_neq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpb_neq_p(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_pcmpb_neq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_eql(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_eql(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_eql_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_eql_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_ge_m(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_ge_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_ge_m_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_ge_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_ge_s(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_ge_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_ge_s_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_ge_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_ge_u(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_ge_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_ge_u_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_ge_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_gt_m(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_gt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_gt_m_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_gt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_gt_s(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_gt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_gt_s_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_gt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_gt_u(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_gt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_gt_u_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_gt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_le_m(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_le_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_le_m_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_le_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_le_s(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_le_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_le_s_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_le_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_le_u(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_le_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_le_u_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_le_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_lt_m(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_lt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_lt_m_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_lt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_lt_s(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_lt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_lt_s_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_lt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_lt_u(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_lt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_lt_u_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_lt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpd_neq(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_neq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpd_neq_p(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_pcmpd_neq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_eql(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_eql(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_eql_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_eql_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_ge_m(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_ge_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_ge_m_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_ge_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_ge_s(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_ge_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_ge_s_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_ge_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_ge_u(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_ge_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_ge_u_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_ge_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_gt_m(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_gt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_gt_m_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_gt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_gt_s(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_gt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_gt_s_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_gt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_gt_u(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_gt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_gt_u_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_gt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_le_m(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_le_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_le_m_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_le_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_le_s(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_le_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_le_s_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_le_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_le_u(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_le_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_le_u_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_le_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_lt_m(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_lt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_lt_m_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_lt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_lt_s(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_lt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_lt_s_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_lt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_lt_u(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_lt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_lt_u_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_lt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmph_neq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_neq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmph_neq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_pcmph_neq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_eql(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_eql(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_eql_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_eql_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_ge_m(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_ge_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_ge_m_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_ge_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_ge_s(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_ge_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_ge_s_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_ge_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_ge_u(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_ge_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_ge_u_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_ge_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_gt_m(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_gt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_gt_m_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_gt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_gt_s(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_gt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_gt_s_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_gt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_gt_u(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_gt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_gt_u_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_gt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_le_m(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_le_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_le_m_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_le_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_le_s(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_le_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_le_s_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_le_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_le_u(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_le_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_le_u_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_le_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_lt_m(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_lt_m(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_lt_m_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_lt_m_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_lt_s(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_lt_s(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_lt_s_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_lt_s_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_lt_u(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_lt_u(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_lt_u_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_lt_u_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pcmpl_neq(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_neq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pcmpl_neq_p(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pcmpl_neq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_eq_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_eq_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_eq_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_eq_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_eq_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_eq_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_eq_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_eq_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_false_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_false_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_false_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_false_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_ge_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ge_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_ge_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ge_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_ge_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ge_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_ge_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ge_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_gt_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_gt_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_gt_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_gt_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_gt_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_gt_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_gt_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_gt_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_le_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_le_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_le_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_le_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_le_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_le_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_le_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_le_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_lt_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_lt_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_lt_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_lt_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_lt_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_lt_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_lt_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_lt_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_ne_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ne_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_ne_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ne_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_ne_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ne_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_ne_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_ne_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_or_oq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_or_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_or_oq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_or_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_true_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_true_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_true_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_true_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pdcmp_un_uq(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_un_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pdcmp_un_uq_p(
  double s1, double s2
)
{
  return __builtin_elcore32_pdcmp_un_uq_p(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__peor(
  pred_t s1, pred_t s2
)
{
  return __builtin_elcore32_peor(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__peor_i(
  const int8_t s1, pred_t s2
) __attribute__((
  enable_if((-15 <= s1 && s1 <= 15),
            "s1 must be IMM: [-15...15]")
))
{
  return __builtin_elcore32_peor_i(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_eq_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_eq_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_eq_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_eq_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_eq_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_eq_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_eq_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_eq_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_false_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_false_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_false_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_false_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_ge_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ge_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_ge_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ge_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_ge_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ge_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_ge_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ge_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_gt_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_gt_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_gt_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_gt_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_gt_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_gt_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_gt_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_gt_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_le_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_le_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_le_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_le_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_le_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_le_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_le_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_le_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_lt_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_lt_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_lt_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_lt_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_lt_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_lt_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_lt_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_lt_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_ne_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ne_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_ne_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ne_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_ne_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ne_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_ne_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_ne_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_or_oq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_or_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_or_oq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_or_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_true_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_true_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_true_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_true_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pfcmp_un_uq(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_un_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__pfcmp_un_uq_p(
  float s1, float s2
)
{
  return __builtin_elcore32_pfcmp_un_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_eq_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_eq_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_eq_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_eq_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_eq_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_eq_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_eq_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_eq_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_false_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_false_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_false_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_false_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_ge_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ge_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_ge_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ge_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_ge_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ge_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_ge_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ge_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_gt_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_gt_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_gt_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_gt_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_gt_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_gt_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_gt_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_gt_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_le_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_le_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_le_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_le_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_le_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_le_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_le_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_le_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_lt_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_lt_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_lt_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_lt_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_lt_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_lt_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_lt_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_lt_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_ne_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ne_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_ne_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ne_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_ne_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ne_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_ne_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_ne_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_or_oq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_or_oq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_or_oq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_or_oq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_true_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_true_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_true_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_true_uq_p(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__phcmp_un_uq(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_un_uq(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__phcmp_un_uq_p(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_phcmp_un_uq_p(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__pi(
  
)
{
  return __builtin_elcore32_pi();
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__pmuxd(
  int64_t s1, int64_t s2, pred_t s3
)
{
  return __builtin_elcore32_pmuxd(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__pmuxl(
  int32_t s1, int32_t s2, pred_t s3
)
{
  return __builtin_elcore32_pmuxl(s1, s2, s3);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__por(
  pred_t s1, pred_t s2
)
{
  return __builtin_elcore32_por(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__porand(
  pred_t s1, pred_t s2, pred_t s3
)
{
  return __builtin_elcore32_porand(s1, s2, s3);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
__poror(
  pred_t s1, pred_t s2, pred_t s3
)
{
  return __builtin_elcore32_poror(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__ptrd_def(
  int64_t def, int64_t s1, pred_t s2
)
{
  return __builtin_elcore32_ptrd_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__ptrl_def(
  int32_t def, int32_t s1, pred_t s2
)
{
  return __builtin_elcore32_ptrl_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__reml(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_reml(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__remlu(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_remlu(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddb_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddb_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddb_sat_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddb_sat_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddbu_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddbu_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddbu_sat_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddbu_sat_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddh_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddh_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddh_sat_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddh_sat_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddhu_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddhu_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddhu_sat_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddhu_sat_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddl_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddl_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddl_sat_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddl_sat_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddlu_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddlu_def(def, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rnddlu_sat_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_rnddlu_sat_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlb_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlb_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlb_sat_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlb_sat_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlbu_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlbu_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlbu_sat_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlbu_sat_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlh_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlh_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlh_sat_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlh_sat_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlhu_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlhu_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rndlhu_sat_def(
  int32_t def, int32_t s
)
{
  return __builtin_elcore32_rndlhu_sat_def(def, s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rolb(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_rolb(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rold(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_rold(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rolh(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_rolh(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__roll(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_roll(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rollm(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_rollm(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rorb(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_rorb(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rord(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_rord(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rorh(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_rorh(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rorl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_rorl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__rorlm(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_rorlm(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__roundd(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_roundd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__roundd_sat(
  int32_t s1, int64_t s2
)
{
  return __builtin_elcore32_roundd_sat(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__roundl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_roundl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__roundl_sat(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_roundl_sat(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rpld(
  pred_t s1, int64_t s2
)
{
  return __builtin_elcore32_rpld(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__rprd(
  pred_t s1, int64_t s2
)
{
  return __builtin_elcore32_rprd(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__rtd(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_rtd(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__rte(
  
)
{
  return __builtin_elcore32_rte();
}

static __inline__ void __DEFAULT_FN_ATTRS
__rti(
  
)
{
  return __builtin_elcore32_rti();
}

static __inline__ void __DEFAULT_FN_ATTRS
__sev0(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_sev0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__sev1(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_sev1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__sevp(
  const uint8_t s1, pred_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_sevp(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__sevr(
  int32_t s
)
{
  return __builtin_elcore32_sevr(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__shufb_def(
  int64_t def, int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_shufb_def(def, s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__shufh_def(
  int64_t def, int32_t s1, int64_t s2, int64_t s3
)
{
  return __builtin_elcore32_shufh_def(def, s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__shufl_def(
  int64_t def, int32_t s1, int64_t s2, int64_t s3
)
{
  return __builtin_elcore32_shufl_def(def, s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__smbd(
  int64_t s
)
{
  return __builtin_elcore32_smbd(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__smbl(
  int32_t s
)
{
  return __builtin_elcore32_smbl(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__splitl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_splitl(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__stop(
  
)
{
  return __builtin_elcore32_stop();
}

static __inline__ void __DEFAULT_FN_ATTRS
__stopdi(
  
)
{
  return __builtin_elcore32_stopdi();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subaddl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_subaddl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subaddl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subaddl_def(def, s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subasrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_subasrl(s1, s2, s3);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__subd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_subd(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__subd_sat(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_subd_sat(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__subd_scl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_subd_scl(s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__subd_scl_rnd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_subd_scl_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subl_rnd(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subl_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subl_sat(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subl_sat(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subl_scl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subl_scl(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subl_scl_rnd(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subl_scl_rnd(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__sublsll(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_sublsll(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__sublsrl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_sublsrl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subsubl(
  int32_t s1, int32_t s2, int32_t s3
)
{
  return __builtin_elcore32_subsubl(s1, s2, s3);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__subsubl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_subsubl_def(def, s1, s2);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__subxl(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_subxl(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__syscall(
  const uint16_t s
) __attribute__((
  enable_if((0 <= s && s <= 65535),
            "s must be IMM: [0...65535]")
))
{
  return __builtin_elcore32_syscall(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__tcd_cmd_cntr(
  
)
{
  return __builtin_elcore32_tcd_cmd_cntr();
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__tcd_instr_cntr(
  
)
{
  return __builtin_elcore32_tcd_instr_cntr();
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__tcd_tic_cntr(
  
)
{
  return __builtin_elcore32_tcd_tic_cntr();
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__tcd_tmr(
  
)
{
  return __builtin_elcore32_tcd_tmr();
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__tcd_tmrc(
  
)
{
  return __builtin_elcore32_tcd_tmrc();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_ae_pc(
  
)
{
  return __builtin_elcore32_tcr_ae_pc();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_allbrcnt(
  
)
{
  return __builtin_elcore32_tcr_allbrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_asid(
  
)
{
  return __builtin_elcore32_tcr_asid();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_ba_pc(
  
)
{
  return __builtin_elcore32_tcr_ba_pc();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_blks(
  
)
{
  return __builtin_elcore32_tcr_blks();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_cacheacccnt(
  
)
{
  return __builtin_elcore32_tcr_cacheacccnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_cnt_run(
  
)
{
  return __builtin_elcore32_tcr_cnt_run();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_cregions(
  
)
{
  return __builtin_elcore32_tcr_cregions();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_csp(
  
)
{
  return __builtin_elcore32_tcr_csp();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_ctrl(
  
)
{
  return __builtin_elcore32_tcr_ctrl();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbcntr(
  
)
{
  return __builtin_elcore32_tcr_dbcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbdcsr(
  
)
{
  return __builtin_elcore32_tcr_dbdcsr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbg_index(
  
)
{
  return __builtin_elcore32_tcr_dbg_index();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbsar(
  
)
{
  return __builtin_elcore32_tcr_dbsar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbsar1(
  
)
{
  return __builtin_elcore32_tcr_dbsar1();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbsar2(
  
)
{
  return __builtin_elcore32_tcr_dbsar2();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dbsar3(
  
)
{
  return __builtin_elcore32_tcr_dbsar3();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dcsr(
  
)
{
  return __builtin_elcore32_tcr_dcsr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dmaskr(
  
)
{
  return __builtin_elcore32_tcr_dmaskr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dqstr(
  
)
{
  return __builtin_elcore32_tcr_dqstr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_drtar(
  
)
{
  return __builtin_elcore32_tcr_drtar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_dvar(
  
)
{
  return __builtin_elcore32_tcr_dvar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_ertar(
  
)
{
  return __builtin_elcore32_tcr_ertar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_evar(
  
)
{
  return __builtin_elcore32_tcr_evar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_idr(
  
)
{
  return __builtin_elcore32_tcr_idr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_imaskr(
  
)
{
  return __builtin_elcore32_tcr_imaskr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_invaddr(
  
)
{
  return __builtin_elcore32_tcr_invaddr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_invctrl(
  
)
{
  return __builtin_elcore32_tcr_invctrl();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_irq_index(
  
)
{
  return __builtin_elcore32_tcr_irq_index();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_irqr(
  
)
{
  return __builtin_elcore32_tcr_irqr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_irtar(
  
)
{
  return __builtin_elcore32_tcr_irtar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_ivar(
  
)
{
  return __builtin_elcore32_tcr_ivar();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_ctrl(
  
)
{
  return __builtin_elcore32_tcr_l0dc_ctrl();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_icntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_icntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_l1rrcntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_l1rrcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_l1rvcntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_l1rvcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_rhcntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_rhcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_rmcntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_rmcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_uccntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_uccntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_whcntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_whcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l0dc_wmcntr(
  
)
{
  return __builtin_elcore32_tcr_l0dc_wmcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_ctrl(
  
)
{
  return __builtin_elcore32_tcr_l1dc_ctrl();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_ecntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_ecntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_l2rcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_l2rcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_l2rrcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_l2rrcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_l2wcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_l2wcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_pcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_pcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_rcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_rcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_rmcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_rmcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_rscntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_rscntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_ucntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_ucntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_wcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_wcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1dc_whcntr(
  
)
{
  return __builtin_elcore32_tcr_l1dc_whcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_ctrl(
  
)
{
  return __builtin_elcore32_tcr_l1ic_ctrl();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_ecntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_ecntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_l2rcntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_l2rcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_l2rrcntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_l2rrcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_pcntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_pcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_rcntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_rcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_rmcntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_rmcntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_rscntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_rscntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_l1ic_ucntr(
  
)
{
  return __builtin_elcore32_tcr_l1ic_ucntr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_la0(
  
)
{
  return __builtin_elcore32_tcr_la0();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_la1(
  
)
{
  return __builtin_elcore32_tcr_la1();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_la2(
  
)
{
  return __builtin_elcore32_tcr_la2();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_la3(
  
)
{
  return __builtin_elcore32_tcr_la3();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lb0(
  
)
{
  return __builtin_elcore32_tcr_lb0();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lb1(
  
)
{
  return __builtin_elcore32_tcr_lb1();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lb2(
  
)
{
  return __builtin_elcore32_tcr_lb2();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lb3(
  
)
{
  return __builtin_elcore32_tcr_lb3();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lc0(
  
)
{
  return __builtin_elcore32_tcr_lc0();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lc1(
  
)
{
  return __builtin_elcore32_tcr_lc1();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lc2(
  
)
{
  return __builtin_elcore32_tcr_lc2();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_lc3(
  
)
{
  return __builtin_elcore32_tcr_lc3();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_m0(
  
)
{
  return __builtin_elcore32_tcr_m0();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_m1(
  
)
{
  return __builtin_elcore32_tcr_m1();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_mbarreg(
  
)
{
  return __builtin_elcore32_tcr_mbarreg();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_misspredcnt(
  
)
{
  return __builtin_elcore32_tcr_misspredcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_mregions(
  
)
{
  return __builtin_elcore32_tcr_mregions();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_pc(
  
)
{
  return __builtin_elcore32_tcr_pc();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_pdnr(
  
)
{
  return __builtin_elcore32_tcr_pdnr();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_pramacccnt(
  
)
{
  return __builtin_elcore32_tcr_pramacccnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_predcnt(
  
)
{
  return __builtin_elcore32_tcr_predcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_reg_base_adrm(
  
)
{
  return __builtin_elcore32_tcr_reg_base_adrm();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseacnt(
  
)
{
  return __builtin_elcore32_tcr_slseacnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slsecalrcnt(
  
)
{
  return __builtin_elcore32_tcr_slsecalrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slsecalwcnt(
  
)
{
  return __builtin_elcore32_tcr_slsecalwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slsecualrcnt(
  
)
{
  return __builtin_elcore32_tcr_slsecualrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slsecualwcnt(
  
)
{
  return __builtin_elcore32_tcr_slsecualwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseealrcnt(
  
)
{
  return __builtin_elcore32_tcr_slseealrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseealwcnt(
  
)
{
  return __builtin_elcore32_tcr_slseealwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseeualrcnt(
  
)
{
  return __builtin_elcore32_tcr_slseeualrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseeualwcnt(
  
)
{
  return __builtin_elcore32_tcr_slseeualwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseircnt(
  
)
{
  return __builtin_elcore32_tcr_slseircnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slseiwcnt(
  
)
{
  return __builtin_elcore32_tcr_slseiwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slsercnt(
  
)
{
  return __builtin_elcore32_tcr_slsercnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_slsewcnt(
  
)
{
  return __builtin_elcore32_tcr_slsewcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_stbrcnt(
  
)
{
  return __builtin_elcore32_tcr_stbrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_swaitregs0(
  
)
{
  return __builtin_elcore32_tcr_swaitregs0();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_swaitregs1(
  
)
{
  return __builtin_elcore32_tcr_swaitregs1();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_tracerctrl(
  
)
{
  return __builtin_elcore32_tcr_tracerctrl();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlseacnt(
  
)
{
  return __builtin_elcore32_tcr_vlseacnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsecalrcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsecalrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsecalwcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsecalwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsecualrcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsecualrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsecualwcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsecualwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsedrcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsedrcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsedwcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsedwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlseircnt(
  
)
{
  return __builtin_elcore32_tcr_vlseircnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlseiwcnt(
  
)
{
  return __builtin_elcore32_tcr_vlseiwcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsercnt(
  
)
{
  return __builtin_elcore32_tcr_vlsercnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vlsewcnt(
  
)
{
  return __builtin_elcore32_tcr_vlsewcnt();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vwaitregs0(
  
)
{
  return __builtin_elcore32_tcr_vwaitregs0();
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tcr_vwaitregs1(
  
)
{
  return __builtin_elcore32_tcr_vwaitregs1();
}

static __inline__ void __DEFAULT_FN_ATTRS
__tdc_cmd_cntr(
  int64_t s
)
{
  return __builtin_elcore32_tdc_cmd_cntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__tdc_instr_cntr(
  int64_t s
)
{
  return __builtin_elcore32_tdc_instr_cntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__tdc_tic_cntr(
  int64_t s
)
{
  return __builtin_elcore32_tdc_tic_cntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__tdc_tmr(
  int64_t s
)
{
  return __builtin_elcore32_tdc_tmr(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__tr1l(
  int64_t s
)
{
  return __builtin_elcore32_tr1l(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trap(
  const uint16_t s
) __attribute__((
  enable_if((0 <= s && s <= 65535),
            "s must be IMM: [0...65535]")
))
{
  return __builtin_elcore32_trap(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_ae_pc(
  int32_t s
)
{
  return __builtin_elcore32_trc_ae_pc(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_allbrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_allbrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_asid(
  int32_t s
)
{
  return __builtin_elcore32_trc_asid(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_ba_pc(
  int32_t s
)
{
  return __builtin_elcore32_trc_ba_pc(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_cacheacccnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_cacheacccnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_cregions(
  int32_t s
)
{
  return __builtin_elcore32_trc_cregions(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_csp(
  int32_t s
)
{
  return __builtin_elcore32_trc_csp(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_ctrl(
  int32_t s
)
{
  return __builtin_elcore32_trc_ctrl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbdcsr(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbdcsr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbg_index(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbg_index(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbsar(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbsar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbsar1(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbsar1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbsar2(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbsar2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dbsar3(
  int32_t s
)
{
  return __builtin_elcore32_trc_dbsar3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dcsr(
  int32_t s
)
{
  return __builtin_elcore32_trc_dcsr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dmaskr(
  int32_t s
)
{
  return __builtin_elcore32_trc_dmaskr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dqstr(
  int32_t s
)
{
  return __builtin_elcore32_trc_dqstr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_drtar(
  int32_t s
)
{
  return __builtin_elcore32_trc_drtar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_dvar(
  int32_t s
)
{
  return __builtin_elcore32_trc_dvar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_ertar(
  int32_t s
)
{
  return __builtin_elcore32_trc_ertar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_evar(
  int32_t s
)
{
  return __builtin_elcore32_trc_evar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_imaskr(
  int32_t s
)
{
  return __builtin_elcore32_trc_imaskr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_invaddr(
  int32_t s
)
{
  return __builtin_elcore32_trc_invaddr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_invctrl(
  int32_t s
)
{
  return __builtin_elcore32_trc_invctrl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_irq_index(
  int32_t s
)
{
  return __builtin_elcore32_trc_irq_index(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_irqr(
  int32_t s
)
{
  return __builtin_elcore32_trc_irqr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_irtar(
  int32_t s
)
{
  return __builtin_elcore32_trc_irtar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_ivar(
  int32_t s
)
{
  return __builtin_elcore32_trc_ivar(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_ctrl(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_ctrl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_icntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_icntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_l1rrcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_l1rrcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_l1rvcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_l1rvcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_rhcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_rhcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_rmcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_rmcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_uccntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_uccntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_whcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_whcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l0dc_wmcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l0dc_wmcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_ctrl(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_ctrl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_ecntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_ecntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_l2rcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_l2rcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_l2rrcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_l2rrcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_l2wcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_l2wcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_pcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_pcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_rcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_rcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_rmcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_rmcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_rscntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_rscntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_ucntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_ucntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_wcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_wcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1dc_whcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1dc_whcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_ctrl(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_ctrl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_ecntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_ecntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_l2rcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_l2rcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_l2rrcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_l2rrcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_pcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_pcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_rcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_rcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_rmcntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_rmcntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_rscntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_rscntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_l1ic_ucntr(
  int32_t s
)
{
  return __builtin_elcore32_trc_l1ic_ucntr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_la0(
  int32_t s
)
{
  return __builtin_elcore32_trc_la0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_la1(
  int32_t s
)
{
  return __builtin_elcore32_trc_la1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_la2(
  int32_t s
)
{
  return __builtin_elcore32_trc_la2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_la3(
  int32_t s
)
{
  return __builtin_elcore32_trc_la3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lb0(
  int32_t s
)
{
  return __builtin_elcore32_trc_lb0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lb1(
  int32_t s
)
{
  return __builtin_elcore32_trc_lb1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lb2(
  int32_t s
)
{
  return __builtin_elcore32_trc_lb2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lb3(
  int32_t s
)
{
  return __builtin_elcore32_trc_lb3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lc0(
  int32_t s
)
{
  return __builtin_elcore32_trc_lc0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lc1(
  int32_t s
)
{
  return __builtin_elcore32_trc_lc1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lc2(
  int32_t s
)
{
  return __builtin_elcore32_trc_lc2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_lc3(
  int32_t s
)
{
  return __builtin_elcore32_trc_lc3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_m0(
  int32_t s
)
{
  return __builtin_elcore32_trc_m0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_m1(
  int32_t s
)
{
  return __builtin_elcore32_trc_m1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_mbarreg(
  int32_t s
)
{
  return __builtin_elcore32_trc_mbarreg(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_misspredcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_misspredcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_mregions(
  int32_t s
)
{
  return __builtin_elcore32_trc_mregions(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_pc(
  int32_t s
)
{
  return __builtin_elcore32_trc_pc(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_pdnr(
  int32_t s
)
{
  return __builtin_elcore32_trc_pdnr(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_pramacccnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_pramacccnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_predcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_predcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_reg_base_adrm(
  int32_t s
)
{
  return __builtin_elcore32_trc_reg_base_adrm(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseacnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseacnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slsecalrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slsecalrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slsecalwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slsecalwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slsecualrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slsecualrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slsecualwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slsecualwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseealrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseealrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseealwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseealwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseeualrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseeualrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseeualwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseeualwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseircnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseircnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slseiwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slseiwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slsercnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slsercnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_slsewcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_slsewcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_stbrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_stbrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_swaitregs0(
  int32_t s
)
{
  return __builtin_elcore32_trc_swaitregs0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_swaitregs1(
  int32_t s
)
{
  return __builtin_elcore32_trc_swaitregs1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_tracerctrl(
  int32_t s
)
{
  return __builtin_elcore32_trc_tracerctrl(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlseacnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlseacnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsecalrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsecalrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsecalwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsecalwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsecualrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsecualrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsecualwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsecualwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsedrcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsedrcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsedwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsedwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlseircnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlseircnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlseiwcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlseiwcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsercnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsercnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vlsewcnt(
  int32_t s
)
{
  return __builtin_elcore32_trc_vlsewcnt(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vwaitregs0(
  int32_t s
)
{
  return __builtin_elcore32_trc_vwaitregs0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__trc_vwaitregs1(
  int32_t s
)
{
  return __builtin_elcore32_trc_vwaitregs1(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__trd(
  int64_t s
)
{
  return __builtin_elcore32_trd(s);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__trl(
  int32_t s
)
{
  return __builtin_elcore32_trl(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
__trl1_def(
  int64_t def, int32_t s
)
{
  return __builtin_elcore32_trl1_def(def, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfe0(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_wfe0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfe1(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_wfe1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfep(
  const uint8_t s1, pred_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_wfep(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfeq0(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_wfeq0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfeq1(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_wfeq1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfeqp(
  const uint8_t s1, pred_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_wfeqp(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfer(
  int32_t s
)
{
  return __builtin_elcore32_wfer(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
__wfme(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_wfme(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
__wrapl_def(
  int32_t def, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_wrapl_def(def, s1, s2);
}


// create-builtins-patch.py end

#ifdef __ELCORE32_EVX__

/* EVX intrinsics */

// This code is autogenerated by create-builtins-patch.py, do not edit!
// Maintainers: pkolomytsev, dtroshkov.

// create-builtins-patch.py create_vector_header

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvand(
  vp_t s1, vp_t s2
)
{
  return __builtin_elcore32_pvand(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pveor(
  vp_t s1, vp_t s2
)
{
  return __builtin_elcore32_pveor(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskb(
  int32_t s
)
{
  return __builtin_elcore32_pvmskb(s);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskb1(
  const uint8_t s
) __attribute__((
  enable_if((0 <= s && s <= 31),
            "s must be IMM: [0...31]")
))
{
  return __builtin_elcore32_pvmskb1(s);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskd(
  int32_t s
)
{
  return __builtin_elcore32_pvmskd(s);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskeb(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pvmskeb(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmsked(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pvmsked(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskeh(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pvmskeh(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskel(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_pvmskel(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskh(
  int32_t s
)
{
  return __builtin_elcore32_pvmskh(s);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvmskl(
  int32_t s
)
{
  return __builtin_elcore32_pvmskl(s);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvor(
  vp_t s1, vp_t s2
)
{
  return __builtin_elcore32_pvor(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvpk(
  vp_t s1, vp_t s2
)
{
  return __builtin_elcore32_pvpk(s1, s2);
}

static __inline__ pred_t __DEFAULT_FN_ATTRS
evx_pvtst(
  const uint8_t s1, vp_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_pvtst(s1, s2);
}

static __inline__ int32_t __DEFAULT_FN_ATTRS
evx_pvtstr_def(
  int32_t def, const uint8_t s1, vp_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_pvtstr_def(def, s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvtstv(
  const uint8_t s1, vp_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_pvtstv(s1, s2);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvupkhi(
  vp_t s
)
{
  return __builtin_elcore32_pvupkhi(s);
}

static __inline__ vp_t __DEFAULT_FN_ATTRS
evx_pvupklo(
  vp_t s
)
{
  return __builtin_elcore32_pvupklo(s);
}

static __inline__ v128i8_t __DEFAULT_FN_ATTRS
evx_v128i8_concat(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_v128i8_concat(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_v128i8_extract_hi(
  v128i8_t s
)
{
  return __builtin_elcore32_v128i8_extract_hi(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_v128i8_extract_lo(
  v128i8_t s
)
{
  return __builtin_elcore32_v128i8_extract_lo(s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_v16f64_concat(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_v16f64_concat(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_v16f64_extract_hi(
  v16f64_t s
)
{
  return __builtin_elcore32_v16f64_extract_hi(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_v16f64_extract_lo(
  v16f64_t s
)
{
  return __builtin_elcore32_v16f64_extract_lo(s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_v16i64_concat(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_v16i64_concat(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_v16i64_extract_hi(
  v16i64_t s
)
{
  return __builtin_elcore32_v16i64_extract_hi(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_v16i64_extract_lo(
  v16i64_t s
)
{
  return __builtin_elcore32_v16i64_extract_lo(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_v32f32_concat(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_v32f32_concat(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_v32f32_extract_hi(
  v32f32_t s
)
{
  return __builtin_elcore32_v32f32_extract_hi(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_v32f32_extract_lo(
  v32f32_t s
)
{
  return __builtin_elcore32_v32f32_extract_lo(s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_v32i32_concat(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_v32i32_concat(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_v32i32_extract_hi(
  v32i32_t s
)
{
  return __builtin_elcore32_v32i32_extract_hi(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_v32i32_extract_lo(
  v32i32_t s
)
{
  return __builtin_elcore32_v32i32_extract_lo(s);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_v64i16_concat(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_v64i16_concat(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_v64i16_extract_hi(
  v64i16_t s
)
{
  return __builtin_elcore32_v64i16_extract_hi(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_v64i16_extract_lo(
  v64i16_t s
)
{
  return __builtin_elcore32_v64i16_extract_lo(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vabsb(
  v64i8_t s
)
{
  return __builtin_elcore32_vabsb(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vabsb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vabsb_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vabsb_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vabsb_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vabsb_sat(
  v64i8_t s
)
{
  return __builtin_elcore32_vabsb_sat(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vabsb_sat_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vabsb_sat_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vabsb_sat_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vabsb_sat_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vabsd(
  v8i64_t s
)
{
  return __builtin_elcore32_vabsd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vabsd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vabsd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vabsd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vabsd_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vabsd_sat(
  v8i64_t s
)
{
  return __builtin_elcore32_vabsd_sat(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vabsd_sat_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vabsd_sat_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vabsd_sat_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vabsd_sat_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vabsh(
  v32i16_t s
)
{
  return __builtin_elcore32_vabsh(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vabsh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vabsh_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vabsh_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vabsh_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vabsh_sat(
  v32i16_t s
)
{
  return __builtin_elcore32_vabsh_sat(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vabsh_sat_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vabsh_sat_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vabsh_sat_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vabsh_sat_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vabsl(
  v16i32_t s
)
{
  return __builtin_elcore32_vabsl(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vabsl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vabsl_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vabsl_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vabsl_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vabsl_sat(
  v16i32_t s
)
{
  return __builtin_elcore32_vabsl_sat(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vabsl_sat_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vabsl_sat_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vabsl_sat_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vabsl_sat_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd2ld(
  v8i64_t s
)
{
  return __builtin_elcore32_vadd2ld(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd2ld_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd2ld_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd2ld_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd2ld_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd2ldu(
  v8i64_t s
)
{
  return __builtin_elcore32_vadd2ldu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd2ldu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd2ldu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd2ldu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd2ldu_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd4hd(
  v8i64_t s
)
{
  return __builtin_elcore32_vadd4hd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd4hd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd4hd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd4hd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd4hd_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd4hdu(
  v8i64_t s
)
{
  return __builtin_elcore32_vadd4hdu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd4hdu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd4hdu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd4hdu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd4hdu_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd8bd(
  v8i64_t s
)
{
  return __builtin_elcore32_vadd8bd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd8bd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd8bd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd8bd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd8bd_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd8bdu(
  v8i64_t s
)
{
  return __builtin_elcore32_vadd8bdu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd8bdu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd8bdu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadd8bdu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vadd8bdu_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_def_mask_i(
  v64i8_t def, vp_t mask, const int8_t s1, v64i8_t s2
) __attribute__((
  enable_if((-127 <= s1 && s1 <= 127),
            "s1 must be IMM: [-127...127]")
))
{
  return __builtin_elcore32_vaddb_def_mask_i(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_i(
  const int8_t s1, v64i8_t s2
) __attribute__((
  enable_if((-127 <= s1 && s1 <= 127),
            "s1 must be IMM: [-127...127]")
))
{
  return __builtin_elcore32_vaddb_i(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_mask_i(
  vp_t mask, const int8_t s1, v64i8_t s2
) __attribute__((
  enable_if((-127 <= s1 && s1 <= 127),
            "s1 must be IMM: [-127...127]")
))
{
  return __builtin_elcore32_vaddb_mask_i(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_sat(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_sat(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_sat_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_sat_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_sat_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_scl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_scl(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_scl_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_scl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_scl_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_scl_rnd(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_scl_rnd(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_scl_rnd_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddb_scl_rnd_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddb_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbheu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbheu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbheu_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbheu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbheu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbheu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhou(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhou(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhou_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhou_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhou_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhou_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhuhi(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhuhi(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhuhi_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhuhi_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhuhi_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhuhi_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhulo(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhulo(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhulo_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhulo_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddbbhulo_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbbhulo_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_sat(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_sat(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_sat_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_sat_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_sat_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_scl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_scl(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_scl_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_scl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_scl_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_scl_rnd(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_scl_rnd(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_scl_rnd_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vaddbu_scl_rnd_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vaddbu_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_sat(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_sat(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_sat_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_sat_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_sat_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_scl(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_scl(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_scl_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_scl_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_scl_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_scl_rnd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_scl_rnd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_scl_rnd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddd_scl_rnd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vaddd_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_sat(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_sat(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_sat_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_sat_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_sat_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_scl(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_scl(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_scl_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_scl_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_scl_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_scl_rnd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_scl_rnd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_scl_rnd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vadddu_scl_rnd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vadddu_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_def_mask_i(
  v32i16_t def, vp_t mask, const int16_t s1, v32i16_t s2
) __attribute__((
  enable_if((-32767 <= s1 && s1 <= 32767),
            "s1 must be IMM: [-32767...32767]")
))
{
  return __builtin_elcore32_vaddh_def_mask_i(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_i(
  const int16_t s1, v32i16_t s2
) __attribute__((
  enable_if((-32767 <= s1 && s1 <= 32767),
            "s1 must be IMM: [-32767...32767]")
))
{
  return __builtin_elcore32_vaddh_i(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_mask_i(
  vp_t mask, const int16_t s1, v32i16_t s2
) __attribute__((
  enable_if((-32767 <= s1 && s1 <= 32767),
            "s1 must be IMM: [-32767...32767]")
))
{
  return __builtin_elcore32_vaddh_mask_i(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_sat(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_sat(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_sat_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_sat_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_sat_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_scl(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_scl(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_scl_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_scl_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_scl_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_scl_rnd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_scl_rnd(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_scl_rnd_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddh_scl_rnd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddh_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhleu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhleu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhleu_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhleu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhleu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhleu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhlou(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhlou(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhlou_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhlou_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhlou_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhlou_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhluhi(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhluhi(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhluhi_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhluhi_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhluhi_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhluhi_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhlulo(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhlulo(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhlulo_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhlulo_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddhhlulo_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhhlulo_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_sat(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_sat(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_sat_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_sat_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_sat_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_scl(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_scl(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_scl_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_scl_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_scl_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_scl_rnd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_scl_rnd(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_scl_rnd_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vaddhu_scl_rnd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vaddhu_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_def_mask_i(
  v16i32_t def, vp_t mask, const int32_t s1, v16i32_t s2
) __attribute__((
  enable_if((-2147483647 <= s1 && s1 <= 2147483647),
            "s1 must be IMM: [-2147483647...2147483647]")
))
{
  return __builtin_elcore32_vaddl_def_mask_i(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_i(
  const int32_t s1, v16i32_t s2
) __attribute__((
  enable_if((-2147483647 <= s1 && s1 <= 2147483647),
            "s1 must be IMM: [-2147483647...2147483647]")
))
{
  return __builtin_elcore32_vaddl_i(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_mask_i(
  vp_t mask, const int32_t s1, v16i32_t s2
) __attribute__((
  enable_if((-2147483647 <= s1 && s1 <= 2147483647),
            "s1 must be IMM: [-2147483647...2147483647]")
))
{
  return __builtin_elcore32_vaddl_mask_i(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_sat(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_sat(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_sat_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_sat_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_sat_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_scl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_scl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_scl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_scl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_scl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_scl_rnd(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_scl_rnd(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_scl_rnd_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddl_scl_rnd_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddl_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddlldeu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlldeu(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddlldeu_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlldeu_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddlldeu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlldeu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddlldou(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlldou(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddlldou_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlldou_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddlldou_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlldou_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_sat(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_sat(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_sat_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_sat_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_sat_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_scl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_scl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_scl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_scl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_scl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_scl_rnd(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_scl_rnd(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_scl_rnd_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_scl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vaddlu_scl_rnd_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vaddlu_scl_rnd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddredd(
  v8i64_t s
)
{
  return __builtin_elcore32_vaddredd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddredd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vaddredd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vaddredd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vaddredd_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vaddredrd(
  v8i64_t s
)
{
  return __builtin_elcore32_vaddredrd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vaddredrd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vaddredrd_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtbhi(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtbhi(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtbhi_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtbhi_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtbhi_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtbhi_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtblo(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtblo(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtblo_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtblo_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtblo_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtblo_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valthhi(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valthhi(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valthhi_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valthhi_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valthhi_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valthhi_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valthlo(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valthlo(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valthlo_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valthlo_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valthlo_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valthlo_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtlinbhi(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtlinbhi(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtlinbhi_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtlinbhi_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtlinbhi_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtlinbhi_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtlinblo(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtlinblo(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtlinblo_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtlinblo_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_valtlinblo_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_valtlinblo_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_valtlindhi(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_valtlindhi(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_valtlindhi_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_valtlindhi_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_valtlindhi_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_valtlindhi_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_valtlindlo(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_valtlindlo(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_valtlindlo_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_valtlindlo_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_valtlindlo_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_valtlindlo_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valtlinhhi(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valtlinhhi(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valtlinhhi_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valtlinhhi_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valtlinhhi_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valtlinhhi_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valtlinhlo(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valtlinhlo(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valtlinhlo_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valtlinhlo_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_valtlinhlo_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_valtlinhlo_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_valtlinlhi(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_valtlinlhi(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_valtlinlhi_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_valtlinlhi_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_valtlinlhi_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_valtlinlhi_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_valtlinllo(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_valtlinllo(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_valtlinllo_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_valtlinllo_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_valtlinllo_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_valtlinllo_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vand(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vand(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vand_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vand_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vand_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vand_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vandc(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vandc(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vandc_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vandc_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vandc_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vandc_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vandi(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vandi(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vandi_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vandi_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vandi_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vandi_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vandredd(
  v8i64_t s
)
{
  return __builtin_elcore32_vandredd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vandredd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vandredd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vandredd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vandredd_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vandredrd(
  v8i64_t s
)
{
  return __builtin_elcore32_vandredrd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vandredrd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vandredrd_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_sat(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_sat(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_sat_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_sat_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_sat_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_scl(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_scl(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_scl_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_scl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vash_scl_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vash_scl_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vasrb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vasrb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_def_mask_i(
  v64i8_t def, vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrb_def_mask_i(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_i(
  const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrb_i(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vasrb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_mask_i(
  vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrb_mask_i(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_rnd(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vasrb_rnd(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_rnd_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vasrb_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_rnd_def_mask_i(
  v64i8_t def, vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrb_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_rnd_i(
  const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrb_rnd_i(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_rnd_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vasrb_rnd_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vasrb_rnd_mask_i(
  vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrb_rnd_mask_i(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vasrd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vasrd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_def_mask_i(
  v8i64_t def, vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_i(
  const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrd_i(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vasrd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_mask_i(
  vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrd_mask_i(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_rnd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vasrd_rnd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_rnd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vasrd_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_rnd_def_mask_i(
  v8i64_t def, vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrd_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_rnd_i(
  const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrd_rnd_i(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_rnd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vasrd_rnd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vasrd_rnd_mask_i(
  vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrd_rnd_mask_i(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vasrh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vasrh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_def_mask_i(
  v32i16_t def, vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrh_def_mask_i(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_i(
  const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrh_i(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vasrh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_mask_i(
  vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrh_mask_i(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_rnd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vasrh_rnd(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_rnd_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vasrh_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_rnd_def_mask_i(
  v32i16_t def, vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrh_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_rnd_i(
  const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrh_rnd_i(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_rnd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vasrh_rnd_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vasrh_rnd_mask_i(
  vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrh_rnd_mask_i(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vasrl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vasrl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_def_mask_i(
  v16i32_t def, vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrl_def_mask_i(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_i(
  const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrl_i(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vasrl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_mask_i(
  vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrl_mask_i(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_rnd(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vasrl_rnd(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_rnd_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vasrl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_rnd_def_mask_i(
  v16i32_t def, vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrl_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_rnd_i(
  const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrl_rnd_i(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_rnd_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vasrl_rnd_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vasrl_rnd_mask_i(
  vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vasrl_rnd_mask_i(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbdint2d(
  v8i64_t s
)
{
  return __builtin_elcore32_vbdint2d(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbdint2d_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vbdint2d_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbdint2d_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vbdint2d_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbint2d(
  v8i64_t s
)
{
  return __builtin_elcore32_vbint2d(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbint2d_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vbint2d_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbint2d_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vbint2d_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbint3d(
  v8i64_t s
)
{
  return __builtin_elcore32_vbint3d(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbint3d_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vbint3d_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vbint3d_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vbint3d_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vbitpushl_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vbitpushl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vbitpushl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vbitpushl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vbitsetl_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vbitsetl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vbitsetl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vbitsetl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclipl_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vclipl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclipl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vclipl_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vclob(
  v64i8_t s
)
{
  return __builtin_elcore32_vclob(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vclob_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vclob_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vclob_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vclob_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vclod(
  v8i64_t s
)
{
  return __builtin_elcore32_vclod(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vclod_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vclod_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vclod_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vclod_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcloh(
  v32i16_t s
)
{
  return __builtin_elcore32_vcloh(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcloh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcloh_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcloh_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcloh_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclol(
  v16i32_t s
)
{
  return __builtin_elcore32_vclol(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclol_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vclol_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclol_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vclol_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va0(
  
)
{
  return __builtin_elcore32_vclrac_va0();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va0_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va0_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va1(
  
)
{
  return __builtin_elcore32_vclrac_va1();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va10(
  
)
{
  return __builtin_elcore32_vclrac_va10();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va10_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va10_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va11(
  
)
{
  return __builtin_elcore32_vclrac_va11();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va11_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va11_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va12(
  
)
{
  return __builtin_elcore32_vclrac_va12();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va12_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va12_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va13(
  
)
{
  return __builtin_elcore32_vclrac_va13();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va13_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va13_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va14(
  
)
{
  return __builtin_elcore32_vclrac_va14();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va14_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va14_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va15(
  
)
{
  return __builtin_elcore32_vclrac_va15();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va15_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va15_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va1_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va1_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va2(
  
)
{
  return __builtin_elcore32_vclrac_va2();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va2_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va2_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va3(
  
)
{
  return __builtin_elcore32_vclrac_va3();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va3_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va3_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va4(
  
)
{
  return __builtin_elcore32_vclrac_va4();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va4_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va4_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va5(
  
)
{
  return __builtin_elcore32_vclrac_va5();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va5_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va5_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va6(
  
)
{
  return __builtin_elcore32_vclrac_va6();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va6_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va6_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va7(
  
)
{
  return __builtin_elcore32_vclrac_va7();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va7_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va7_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va8(
  
)
{
  return __builtin_elcore32_vclrac_va8();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va8_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va8_mask(mask);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va9(
  
)
{
  return __builtin_elcore32_vclrac_va9();
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vclrac_va9_mask(
  vp_t mask
)
{
  return __builtin_elcore32_vclrac_va9_mask(mask);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vclzb(
  v64i8_t s
)
{
  return __builtin_elcore32_vclzb(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vclzb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vclzb_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vclzb_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vclzb_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vclzd(
  v8i64_t s
)
{
  return __builtin_elcore32_vclzd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vclzd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vclzd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vclzd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vclzd_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vclzh(
  v32i16_t s
)
{
  return __builtin_elcore32_vclzh(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vclzh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vclzh_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vclzh_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vclzh_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclzl(
  v16i32_t s
)
{
  return __builtin_elcore32_vclzl(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclzl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vclzl_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vclzl_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vclzl_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhe(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbhe(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhe_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhe_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhe_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhe_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbheu(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbheu(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbheu_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbheu_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbheu_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbheu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhhi(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbhhi(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhhi_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhhi_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhhi_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhhi_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhlo(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbhlo(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhlo_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhlo_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhlo_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhlo_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbho(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbho(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbho_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbho_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbho_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbho_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhou(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbhou(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhou_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhou_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhou_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhou_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhuhi(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbhuhi(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhuhi_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhuhi_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhuhi_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhuhi_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhulo(
  v64i8_t s
)
{
  return __builtin_elcore32_vcvbhulo(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhulo_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhulo_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvbhulo_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vcvbhulo_mask(mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vcvdd(
  v8i64_t s
)
{
  return __builtin_elcore32_vcvdd(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vcvdd_def_mask(
  v8f64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvdd_def_mask(def, mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vcvdd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvdd_mask(mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vcvddu(
  v8i64_t s
)
{
  return __builtin_elcore32_vcvddu(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vcvddu_def_mask(
  v8f64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvddu_def_mask(def, mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vcvddu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvddu_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdf(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vcvdf(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvdf_2v(
  v16i64_t s
)
{
  return __builtin_elcore32_vcvdf(
    evx_v16i64_extract_lo(s),
    evx_v16i64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdf_2v(v16i64_t s)
{
  return __builtin_elcore32_vcvdf_2v(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdf_def_mask(
  v16f32_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vcvdf_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvdf_def_mask_2v(
  v16f32_t def, vp_t mask, v16i64_t s
)
{
  return __builtin_elcore32_vcvdf_def_mask(def, mask,
    evx_v16i64_extract_lo(s),
    evx_v16i64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdf_def_mask_2v(v16f32_t def, vp_t mask, v16i64_t s)
{
  return __builtin_elcore32_vcvdf_def_mask_2v(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdf_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vcvdf_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvdf_mask_2v(
  vp_t mask, v16i64_t s
)
{
  return __builtin_elcore32_vcvdf_mask(mask,
    evx_v16i64_extract_lo(s),
    evx_v16i64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdf_mask_2v(vp_t mask, v16i64_t s)
{
  return __builtin_elcore32_vcvdf_mask_2v(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdfu(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vcvdfu(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvdfu_2v(
  v16i64_t s
)
{
  return __builtin_elcore32_vcvdfu(
    evx_v16i64_extract_lo(s),
    evx_v16i64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdfu_2v(v16i64_t s)
{
  return __builtin_elcore32_vcvdfu_2v(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdfu_def_mask(
  v16f32_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vcvdfu_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvdfu_def_mask_2v(
  v16f32_t def, vp_t mask, v16i64_t s
)
{
  return __builtin_elcore32_vcvdfu_def_mask(def, mask,
    evx_v16i64_extract_lo(s),
    evx_v16i64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdfu_def_mask_2v(v16f32_t def, vp_t mask, v16i64_t s)
{
  return __builtin_elcore32_vcvdfu_def_mask_2v(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdfu_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vcvdfu_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvdfu_mask_2v(
  vp_t mask, v16i64_t s
)
{
  return __builtin_elcore32_vcvdfu_mask(mask,
    evx_v16i64_extract_lo(s),
    evx_v16i64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvdfu_mask_2v(vp_t mask, v16i64_t s)
{
  return __builtin_elcore32_vcvdfu_mask_2v(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvdl_sat(
  v8i64_t s
)
{
  return __builtin_elcore32_vcvdl_sat(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvdl_sat_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvdl_sat_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvdl_sat_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvdl_sat_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvdlu_sat(
  v8i64_t s
)
{
  return __builtin_elcore32_vcvdlu_sat(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvdlu_sat_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvdlu_sat_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvdlu_sat_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vcvdlu_sat_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhb_sat(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhb_sat(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhb_sat_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhb_sat_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhb_sat_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhb_sat_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhbu_sat(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhbu_sat(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhbu_sat_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhbu_sat_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhbu_sat_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhbu_sat_mask(mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvhf(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhf(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvhf_def_mask(
  v32f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhf_def_mask(def, mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvhf_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhf_mask(mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvhfu(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhfu(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvhfu_def_mask(
  v32f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhfu_def_mask(def, mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvhfu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhfu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhh(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhh(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhh_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhh_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhh_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhhu(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhhu(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhhu_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvhhu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhhu_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhle(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhle(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhle_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhle_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhle_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhle_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhleu(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhleu(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhleu_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhleu_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhleu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhleu_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlhi(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhlhi(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlhi_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlhi_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlhi_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlhi_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhllo(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhllo(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhllo_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhllo_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhllo_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhllo_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlo(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhlo(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlo_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlo_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlo_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlo_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlou(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhlou(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlou_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlou_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlou_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlou_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhluhi(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhluhi(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhluhi_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhluhi_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhluhi_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhluhi_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlulo(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvhlulo(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlulo_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlulo_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvhlulo_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvhlulo_mask(mask, s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vcvid(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvid(s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vcvid_def_mask(
  v16f64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvid_def_mask(def, mask, s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vcvid_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvid_mask(mask, s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vcvidu(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvidu(s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vcvidu_def_mask(
  v16f64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvidu_def_mask(def, mask, s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vcvidu_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvidu_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvif(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvif(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvif_def_mask(
  v16f32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvif_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvif_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvif_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvifu(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvifu(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvifu_def_mask(
  v16f32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvifu_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvifu_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvifu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvih(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vcvih(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvih_2v(
  v32i32_t s
)
{
  return __builtin_elcore32_vcvih(
    evx_v32i32_extract_lo(s),
    evx_v32i32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvih_2v(v32i32_t s)
{
  return __builtin_elcore32_vcvih_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvih_def_mask(
  v32i16_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vcvih_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvih_def_mask_2v(
  v32i16_t def, vp_t mask, v32i32_t s
)
{
  return __builtin_elcore32_vcvih_def_mask(def, mask,
    evx_v32i32_extract_lo(s),
    evx_v32i32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvih_def_mask_2v(v32i16_t def, vp_t mask, v32i32_t s)
{
  return __builtin_elcore32_vcvih_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvih_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vcvih_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvih_mask_2v(
  vp_t mask, v32i32_t s
)
{
  return __builtin_elcore32_vcvih_mask(mask,
    evx_v32i32_extract_lo(s),
    evx_v32i32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvih_mask_2v(vp_t mask, v32i32_t s)
{
  return __builtin_elcore32_vcvih_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvihu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vcvihu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvihu_2v(
  v32i32_t s
)
{
  return __builtin_elcore32_vcvihu(
    evx_v32i32_extract_lo(s),
    evx_v32i32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvihu_2v(v32i32_t s)
{
  return __builtin_elcore32_vcvihu_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvihu_def_mask(
  v32i16_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vcvihu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvihu_def_mask_2v(
  v32i16_t def, vp_t mask, v32i32_t s
)
{
  return __builtin_elcore32_vcvihu_def_mask(def, mask,
    evx_v32i32_extract_lo(s),
    evx_v32i32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvihu_def_mask_2v(v32i16_t def, vp_t mask, v32i32_t s)
{
  return __builtin_elcore32_vcvihu_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvihu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vcvihu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vcvihu_mask_2v(
  vp_t mask, v32i32_t s
)
{
  return __builtin_elcore32_vcvihu_mask(mask,
    evx_v32i32_extract_lo(s),
    evx_v32i32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vcvihu_mask_2v(vp_t mask, v32i32_t s)
{
  return __builtin_elcore32_vcvihu_mask_2v(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvlde(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvlde(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvlde_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvlde_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvlde_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvlde_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldeu(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvldeu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldeu_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvldeu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldeu_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvldeu_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldo(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvldo(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldo_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvldo_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldo_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvldo_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldou(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvldou(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldou_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvldou_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vcvldou_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvldou_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvlh_sat(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvlh_sat(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvlh_sat_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvlh_sat_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvlh_sat_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvlh_sat_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvlhu_sat(
  v16i32_t s
)
{
  return __builtin_elcore32_vcvlhu_sat(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvlhu_sat_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvlhu_sat_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vcvlhu_sat_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vcvlhu_sat_mask(mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvlinhf(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvlinhf(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvlinhf_def_mask(
  v32f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvlinhf_def_mask(def, mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvlinhf_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvlinhf_mask(mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvlinhfu(
  v32i16_t s
)
{
  return __builtin_elcore32_vcvlinhfu(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvlinhfu_def_mask(
  v32f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvlinhfu_def_mask(def, mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vcvlinhfu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vcvlinhfu_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvrf(
  const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vcvrf(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvrf_def_mask(
  v16f32_t def, vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vcvrf_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vcvrf_mask(
  vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vcvrf_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdadd(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdadd(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdadd_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdadd_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdadd_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdadd_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdceil(
  v8f64_t s
)
{
  return __builtin_elcore32_vdceil(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdceil_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdceil_def_mask(def, mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdceil_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdceil_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdclass(
  v8f64_t s
)
{
  return __builtin_elcore32_vdclass(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdclass_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdclass_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdclass_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdclass_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_ceil(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_ceil(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_ceil_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_ceil_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_ceil_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_ceil_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_floor(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_floor(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_floor_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_floor_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_floor_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_floor_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_round(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_round(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_round_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_round_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_round_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_round_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_trunc(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_trunc(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_trunc_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_trunc_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvd_trunc_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvd_trunc_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_ceil(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_ceil(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_ceil_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_ceil_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_ceil_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_ceil_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_floor(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_floor(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_floor_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_floor_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_floor_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_floor_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_round(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_round(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_round_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_round_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_round_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_round_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_trunc(
  v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_trunc(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_trunc_def_mask(
  v8i64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_trunc_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdcvdu_trunc_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdcvdu_trunc_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcvi(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdcvi(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdcvi_2v(
  v16f64_t s
)
{
  return __builtin_elcore32_vdcvi(
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcvi_2v(v16f64_t s)
{
  return __builtin_elcore32_vdcvi_2v(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcvi_def_mask(
  v16i32_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdcvi_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdcvi_def_mask_2v(
  v16i32_t def, vp_t mask, v16f64_t s
)
{
  return __builtin_elcore32_vdcvi_def_mask(def, mask,
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcvi_def_mask_2v(v16i32_t def, vp_t mask, v16f64_t s)
{
  return __builtin_elcore32_vdcvi_def_mask_2v(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcvi_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdcvi_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdcvi_mask_2v(
  vp_t mask, v16f64_t s
)
{
  return __builtin_elcore32_vdcvi_mask(mask,
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcvi_mask_2v(vp_t mask, v16f64_t s)
{
  return __builtin_elcore32_vdcvi_mask_2v(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcviu(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdcviu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdcviu_2v(
  v16f64_t s
)
{
  return __builtin_elcore32_vdcviu(
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcviu_2v(v16f64_t s)
{
  return __builtin_elcore32_vdcviu_2v(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcviu_def_mask(
  v16i32_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdcviu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdcviu_def_mask_2v(
  v16i32_t def, vp_t mask, v16f64_t s
)
{
  return __builtin_elcore32_vdcviu_def_mask(def, mask,
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcviu_def_mask_2v(v16i32_t def, vp_t mask, v16f64_t s)
{
  return __builtin_elcore32_vdcviu_def_mask_2v(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcviu_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdcviu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdcviu_mask_2v(
  vp_t mask, v16f64_t s
)
{
  return __builtin_elcore32_vdcviu_mask(mask,
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdcviu_mask_2v(vp_t mask, v16f64_t s)
{
  return __builtin_elcore32_vdcviu_mask_2v(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vdfcv(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdfcv(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdfcv_2v(
  v16f64_t s
)
{
  return __builtin_elcore32_vdfcv(
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vdfcv_2v(v16f64_t s)
{
  return __builtin_elcore32_vdfcv_2v(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vdfcv_def_mask(
  v16f32_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdfcv_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdfcv_def_mask_2v(
  v16f32_t def, vp_t mask, v16f64_t s
)
{
  return __builtin_elcore32_vdfcv_def_mask(def, mask,
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vdfcv_def_mask_2v(v16f32_t def, vp_t mask, v16f64_t s)
{
  return __builtin_elcore32_vdfcv_def_mask_2v(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vdfcv_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdfcv_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vdfcv_mask_2v(
  vp_t mask, v16f64_t s
)
{
  return __builtin_elcore32_vdfcv_mask(mask,
    evx_v16f64_extract_lo(s),
    evx_v16f64_extract_hi(s));
}
static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vdfcv_mask_2v(vp_t mask, v16f64_t s)
{
  return __builtin_elcore32_vdfcv_mask_2v(mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdfloor(
  v8f64_t s
)
{
  return __builtin_elcore32_vdfloor(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdfloor_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdfloor_def_mask(def, mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdfloor_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdfloor_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiff14hu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiff14hu(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiff14hu_def_mask(
  v8i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiff14hu_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiff14hu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiff14hu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiff24bu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiff24bu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiff24bu_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiff24bu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiff24bu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiff24bu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vdiffb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vdiffb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vdiffb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vdiffbu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vdiffbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vdiffbu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffbu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vdiffd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vdiffd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vdiffd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffdu(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vdiffdu(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffdu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vdiffdu_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffdu_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vdiffdu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vdiffh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vdiffh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vdiffh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vdiffhu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vdiffhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vdiffhu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffhu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiffl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vdiffl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiffl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vdiffl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiffl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vdiffl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdifflu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vdifflu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdifflu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vdifflu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdifflu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vdifflu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffr14hu_def(
  v8i64_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffr14hu_def(def, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vdiffr14hu_def_mask(
  v8i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vdiffr14hu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiffr24bu_def(
  v16i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffr24bu_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vdiffr24bu_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vdiffr24bu_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmax(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmax(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmax_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmax_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmax_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmax_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmin(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmin(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmin_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmin_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmin_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmin_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpa12(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpa12(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpa12_def_mask(
  v8f64_t def, vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpa12_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpa12_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpa12_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va0_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va0_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va0_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va0_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va10_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va10_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va10_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va10_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va11_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va11_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va11_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va11_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va12_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va12_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va12_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va12_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va13_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va13_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va13_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va13_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va14_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va14_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va14_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va14_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va15_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va15_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va15_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va15_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va1_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va1_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va1_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va1_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va2_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va2_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va2_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va2_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va3_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va3_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va3_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va3_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va4_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va4_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va4_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va4_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va5_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va5_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va5_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va5_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va6_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va6_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va6_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va6_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va7_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va7_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va7_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va7_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va8_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va8_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va8_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va8_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va9_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va9_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va9_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac12_va9_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac12_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va0_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va0_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va0_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va0_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va10_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va10_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va10_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va10_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va11_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va11_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va11_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va11_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va12_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va12_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va12_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va12_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va13_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va13_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va13_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va13_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va14_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va14_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va14_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va14_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va15_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va15_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va15_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va15_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va1_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va1_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va1_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va1_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va2_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va2_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va2_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va2_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va3_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va3_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va3_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va3_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va4_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va4_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va4_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va4_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va5_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va5_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va5_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va5_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va6_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va6_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va6_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va6_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va7_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va7_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va7_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va7_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va8_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va8_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va8_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va8_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va9_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va9_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va9_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac2_va9_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpac2_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va0_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va0_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va0_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va0_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va10_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va10_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va10_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va10_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va11_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va11_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va11_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va11_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va12_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va12_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va12_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va12_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va13_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va13_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va13_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va13_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va14_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va14_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va14_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va14_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va15_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va15_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va15_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va15_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va1_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va1_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va1_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va1_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va2_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va2_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va2_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va2_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va3_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va3_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va3_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va3_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va4_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va4_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va4_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va4_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va5_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va5_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va5_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va5_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va6_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va6_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va6_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va6_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va7_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va7_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va7_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va7_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va8_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va8_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va8_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va8_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va9_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va9_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va9_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpac_va9_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpac_va9_d4_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpar_def(
  v8f64_t def, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpar_def(def, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpar_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpar_def_mask(def, mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va0_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va0_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va0_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va0_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va10_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va10_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va10_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va10_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va11_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va11_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va11_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va11_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va12_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va12_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va12_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va12_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va13_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va13_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va13_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va13_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va14_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va14_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va14_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va14_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va15_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va15_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va15_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va15_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va1_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va1_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va1_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va1_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va2_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va2_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va2_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va2_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va3_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va3_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va3_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va3_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va4_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va4_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va4_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va4_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va5_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va5_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va5_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va5_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va6_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va6_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va6_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va6_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va7_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va7_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va7_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va7_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va8_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va8_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va8_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va8_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va9_d0(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va9_d0_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va9_d4(
  v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc2_va9_d4_mask(
  vp_t mask, v16f64_t s1, v16f64_t s2
)
{
  return __builtin_elcore32_vdmpsc2_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va0_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va0_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va0_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va0_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va10_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va10_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va10_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va10_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va11_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va11_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va11_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va11_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va12_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va12_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va12_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va12_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va13_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va13_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va13_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va13_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va14_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va14_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va14_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va14_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va15_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va15_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va15_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va15_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va1_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va1_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va1_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va1_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va2_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va2_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va2_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va2_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va3_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va3_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va3_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va3_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va4_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va4_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va4_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va4_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va5_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va5_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va5_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va5_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va6_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va6_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va6_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va6_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va7_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va7_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va7_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va7_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va8_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va8_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va8_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va8_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va9_d0(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va9_d0_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va9_d4(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmpsc_va9_d4_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsc_va9_d4_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpsr_def(
  v8f64_t def, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsr_def(def, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpsr_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpsr_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpy(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpy(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpy_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpy_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdmpy_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdmpy_mask(mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vdmx(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmx(s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vdmx_def_mask(
  v16i64_t def, vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmx_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vdmx_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmx_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va0_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va0_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va0_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va0_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va10_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va10_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va10_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va10_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va11_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va11_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va11_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va11_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va12_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va12_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va12_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va12_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va13_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va13_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va13_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va13_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va14_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va14_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va14_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va14_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va15_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va15_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va15_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va15_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va1_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va1_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va1_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va1_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va2_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va2_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va2_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va2_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va3_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va3_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va3_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va3_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va4_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va4_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va4_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va4_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va5_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va5_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va5_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va5_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va6_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va6_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va6_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va6_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va7_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va7_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va7_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va7_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va8_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va8_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va8_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va8_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va9_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va9_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va9_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxac_va9_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxac_va9_d4_mask(mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vdmxj(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxj(s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vdmxj_def_mask(
  v16i64_t def, vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxj_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vdmxj_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxj_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va0_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va0_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va0_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va0_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va10_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va10_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va10_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va10_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va11_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va11_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va11_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va11_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va12_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va12_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va12_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va12_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va13_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va13_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va13_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va13_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va14_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va14_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va14_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va14_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va15_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va15_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va15_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va15_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va1_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va1_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va1_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va1_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va2_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va2_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va2_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va2_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va3_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va3_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va3_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va3_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va4_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va4_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va4_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va4_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va5_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va5_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va5_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va5_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va6_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va6_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va6_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va6_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va7_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va7_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va7_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va7_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va8_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va8_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va8_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va8_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va9_d0(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va9_d0_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va9_d4(
  v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vdmxjac_va9_d4_mask(
  vp_t mask, v16i64_t s1, v16i64_t s2
)
{
  return __builtin_elcore32_vdmxjac_va9_d4_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdround(
  v8f64_t s
)
{
  return __builtin_elcore32_vdround(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdround_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdround_def_mask(def, mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdround_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdround_mask(mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdsub(
  v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdsub(s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdsub_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdsub_def_mask(def, mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdsub_mask(
  vp_t mask, v8f64_t s1, v8f64_t s2
)
{
  return __builtin_elcore32_vdsub_mask(mask, s1, s2);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdtrunc(
  v8f64_t s
)
{
  return __builtin_elcore32_vdtrunc(s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdtrunc_def_mask(
  v8f64_t def, vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdtrunc_def_mask(def, mask, s);
}

static __inline__ v8f64_t __DEFAULT_FN_ATTRS
evx_vdtrunc_mask(
  vp_t mask, v8f64_t s
)
{
  return __builtin_elcore32_vdtrunc_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_veor(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_veor(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_veor_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_veor_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_veor_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_veor_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_veorredd(
  v8i64_t s
)
{
  return __builtin_elcore32_veorredd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_veorredd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_veorredd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_veorredd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_veorredd_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_veorredrd(
  v8i64_t s
)
{
  return __builtin_elcore32_veorredrd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_veorredrd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_veorredrd_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfadd(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfadd(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfadd2(
  v16f32_t s
)
{
  return __builtin_elcore32_vfadd2(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfadd2_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfadd2_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfadd2_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfadd2_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfadd_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfadd_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfadd_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfadd_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfaddred(
  v16f32_t s
)
{
  return __builtin_elcore32_vfaddred(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfaddred_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfaddred_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfaddred_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfaddred_mask(mask, s);
}

static __inline__ float __DEFAULT_FN_ATTRS
evx_vfaddredr(
  v16f32_t s
)
{
  return __builtin_elcore32_vfaddredr(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
evx_vfaddredr_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfaddredr_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfaj(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfaj(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfaj_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfaj_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfaj_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfaj_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfceil(
  v16f32_t s
)
{
  return __builtin_elcore32_vfceil(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfceil_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfceil_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfceil_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfceil_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfclass(
  v16f32_t s
)
{
  return __builtin_elcore32_vfclass(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfclass_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfclass_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfclass_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfclass_mask(mask, s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vfcvd(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvd(s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vfcvd_def_mask(
  v16i64_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvd_def_mask(def, mask, s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vfcvd_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvd_mask(mask, s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vfcvdu(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvdu(s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vfcvdu_def_mask(
  v16i64_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvdu_def_mask(def, mask, s);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vfcvdu_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvdu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvh(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvh_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_ceil(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_ceil(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_ceil_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_ceil(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_ceil_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvh_ceil_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_ceil_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_ceil_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_ceil_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_ceil_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_ceil_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_ceil_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_ceil_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_ceil_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_ceil_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_ceil_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_ceil_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_ceil_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_floor(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_floor(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_floor_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_floor(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_floor_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvh_floor_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_floor_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_floor_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_floor_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_floor_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_floor_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_floor_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_floor_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_floor_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_floor_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_floor_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_floor_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_round(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_round(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_round_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_round(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_round_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvh_round_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_round_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_round_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_round_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_round_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_round_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_round_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_round_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_round_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_round_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_round_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_round_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_round_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_trunc(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_trunc(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_trunc_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_trunc(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_trunc_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvh_trunc_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_trunc_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_trunc_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_trunc_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_trunc_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_trunc_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_trunc_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvh_trunc_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvh_trunc_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvh_trunc_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvh_trunc_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvh_trunc_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_ceil(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_ceil(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_ceil_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_ceil(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_ceil_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_ceil_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_ceil_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_ceil_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_ceil_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_ceil_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_ceil_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_ceil_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_ceil_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_ceil_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_ceil_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_ceil_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_ceil_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_ceil_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_floor(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_floor(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_floor_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_floor(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_floor_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_floor_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_floor_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_floor_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_floor_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_floor_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_floor_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_floor_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_floor_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_floor_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_floor_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_floor_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_floor_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_round(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_round(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_round_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_round(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_round_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_round_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_round_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_round_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_round_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_round_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_round_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_round_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_round_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_round_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_round_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_round_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_round_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_round_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_trunc(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_trunc(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_trunc_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_trunc(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_trunc_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_trunc_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_trunc_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_trunc_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_trunc_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_trunc_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_trunc_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_trunc_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvhu_trunc_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvhu_trunc_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvhu_trunc_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvhu_trunc_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvhu_trunc_mask_2v(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvi(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_ceil(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_ceil(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_ceil_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_ceil_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_ceil_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_ceil_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_floor(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_floor(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_floor_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_floor_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_floor_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_floor_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_round(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_round(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_round_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_round_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_round_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_round_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_trunc(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_trunc(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_trunc_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_trunc_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvi_trunc_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcvi_trunc_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcviu(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_ceil(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_ceil(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_ceil_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_ceil_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_ceil_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_ceil_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_floor(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_floor(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_floor_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_floor_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_floor_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_floor_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_round(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_round(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_round_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_round_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_round_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_round_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_trunc(
  v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_trunc(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_trunc_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_trunc_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcviu_trunc_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfcviu_trunc_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_ceil(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_ceil(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_ceil_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_ceil(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_ceil_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_ceil_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_ceil_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_ceil_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_ceil_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_ceil_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_ceil_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_ceil_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_ceil_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_ceil_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_ceil_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_ceil_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_ceil_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_ceil_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_floor(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_floor(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_floor_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_floor(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_floor_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_floor_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_floor_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_floor_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_floor_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_floor_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_floor_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_floor_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_floor_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_floor_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_floor_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_floor_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_floor_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_round(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_round(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_round_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_round(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_round_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_round_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_round_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_round_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_round_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_round_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_round_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_round_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_round_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_round_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_round_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_round_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_round_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_round_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_trunc(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_trunc(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_trunc_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_trunc(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_trunc_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_trunc_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_trunc_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_trunc_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_trunc_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_trunc_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_trunc_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_trunc_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinh_trunc_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinh_trunc_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinh_trunc_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinh_trunc_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinh_trunc_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_ceil(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_ceil(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_ceil_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_ceil(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_ceil_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_ceil_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_ceil_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_ceil_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_ceil_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_ceil_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_ceil_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_ceil_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_ceil_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_ceil_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_ceil_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_ceil_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_ceil_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_ceil_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_floor(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_floor(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_floor_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_floor(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_floor_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_floor_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_floor_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_floor_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_floor_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_floor_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_floor_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_floor_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_floor_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_floor_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_floor_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_floor_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_floor_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_round(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_round(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_round_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_round(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_round_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_round_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_round_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_round_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_round_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_round_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_round_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_round_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_round_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_round_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_round_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_round_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_round_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_round_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_trunc(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_trunc(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_trunc_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_trunc(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_trunc_2v(v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_trunc_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_trunc_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_trunc_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_trunc_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_trunc_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_trunc_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_trunc_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfcvlinhu_trunc_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfcvlinhu_trunc_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfcvlinhu_trunc_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfcvlinhu_trunc_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfcvlinhu_trunc_mask_2v(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvr(
  const uint8_t s1, v16f32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vfcvr(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvr_def_mask(
  v16i32_t def, vp_t mask, const uint8_t s1, v16f32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vfcvr_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfcvr_mask(
  vp_t mask, const uint8_t s1, v16f32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vfcvr_mask(mask, s1, s2);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vfdcv(
  v16f32_t s
)
{
  return __builtin_elcore32_vfdcv(s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vfdcv_def_mask(
  v16f64_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfdcv_def_mask(def, mask, s);
}

static __inline__ v16f64_t __DEFAULT_FN_ATTRS
evx_vfdcv_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfdcv_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vffiltc14(
  v32f32_t s1, v32f32_t s2, v32f32_t s3
)
{
  return __builtin_elcore32_vffiltc14(s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vffiltc14_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2, v32f32_t s3
)
{
  return __builtin_elcore32_vffiltc14_mask(mask, s1, s2, s3);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vffloor(
  v16f32_t s
)
{
  return __builtin_elcore32_vffloor(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vffloor_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vffloor_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vffloor_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vffloor_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vffract0(
  v16f32_t s
)
{
  return __builtin_elcore32_vffract0(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vffract0_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vffract0_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vffract0_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vffract0_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vffractr0(
  v16f32_t s
)
{
  return __builtin_elcore32_vffractr0(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vffractr0_def_mask(
  v16i32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vffractr0_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vffractr0_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vffractr0_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcv(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfhcv(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfhcv_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfhcv(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcv_2v(v32f32_t s)
{
  return __builtin_elcore32_vfhcv_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcv_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfhcv_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfhcv_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfhcv_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcv_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfhcv_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcv_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfhcv_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfhcv_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfhcv_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcv_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfhcv_mask_2v(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcvlin(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfhcvlin(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfhcvlin_2v(
  v32f32_t s
)
{
  return __builtin_elcore32_vfhcvlin(
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcvlin_2v(v32f32_t s)
{
  return __builtin_elcore32_vfhcvlin_2v(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcvlin_def_mask(
  v32i16_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfhcvlin_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfhcvlin_def_mask_2v(
  v32i16_t def, vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfhcvlin_def_mask(def, mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcvlin_def_mask_2v(v32i16_t def, vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfhcvlin_def_mask_2v(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcvlin_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfhcvlin_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
__builtin_elcore32_vfhcvlin_mask_2v(
  vp_t mask, v32f32_t s
)
{
  return __builtin_elcore32_vfhcvlin_mask(mask,
    evx_v32f32_extract_lo(s),
    evx_v32f32_extract_hi(s));
}
static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vfhcvlin_mask_2v(vp_t mask, v32f32_t s)
{
  return __builtin_elcore32_vfhcvlin_mask_2v(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfiltc14buh(
  v64i8_t s1, v64i8_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltc14buh(s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfiltc14buh_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltc14buh_mask(mask, s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfiltc14hh(
  v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltc14hh(s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfiltc14hh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltc14hh_mask(mask, s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfiltc18bub(
  v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vfiltc18bub(s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfiltc18bub_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vfiltc18bub_mask(mask, s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr14buhh(
  v64i8_t s1, v64i8_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltr14buhh(s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr14buhh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltr14buhh_def_mask(def, mask, s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr14buhh_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltr14buhh_mask(mask, s1, s2, s3);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr14hhl(
  v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltr14hhl(s1, s2, s3);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr14hhl_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltr14hhl_def_mask(def, mask, s1, s2, s3);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr14hhl_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vfiltr14hhl_mask(mask, s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr18bubh(
  v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vfiltr18bubh(s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr18bubh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vfiltr18bubh_def_mask(def, mask, s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr18bubh_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vfiltr18bubh_mask(mask, s1, s2, s3);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr22buhh(
  v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vfiltr22buhh(s1, s2, s3, s4, s5);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr22buhh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vfiltr22buhh_def_mask(def, mask, s1, s2, s3, s4, s5);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr22buhh_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vfiltr22buhh_mask(mask, s1, s2, s3, s4, s5);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr22hhl(
  v32i16_t s1, v32i16_t s2, v32i16_t s3, v32i16_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vfiltr22hhl(s1, s2, s3, s4, s5);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr22hhl_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3, v32i16_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vfiltr22hhl_def_mask(def, mask, s1, s2, s3, s4, s5);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr22hhl_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3, v32i16_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vfiltr22hhl_mask(mask, s1, s2, s3, s4, s5);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr24bubh(
  v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v64i8_t s5
)
{
  return __builtin_elcore32_vfiltr24bubh(s1, s2, s3, s4, s5);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr24bubh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v64i8_t s5
)
{
  return __builtin_elcore32_vfiltr24bubh_def_mask(def, mask, s1, s2, s3, s4, s5);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vfiltr24bubh_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v64i8_t s5
)
{
  return __builtin_elcore32_vfiltr24bubh_mask(mask, s1, s2, s3, s4, s5);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr44bubl(
  v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v128i8_t s5
)
{
  return __builtin_elcore32_vfiltr44bubl(s1, s2, s3, s4, s5);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr44bubl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v128i8_t s5
)
{
  return __builtin_elcore32_vfiltr44bubl_def_mask(def, mask, s1, s2, s3, s4, s5);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vfiltr44bubl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2, v64i8_t s3, v64i8_t s4, v128i8_t s5
)
{
  return __builtin_elcore32_vfiltr44bubl_mask(mask, s1, s2, s3, s4, s5);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmax(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmax(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmax2(
  v16f32_t s
)
{
  return __builtin_elcore32_vfmax2(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmax2_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmax2_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmax2_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmax2_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmax_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmax_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmax_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmax_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmaxred(
  v16f32_t s
)
{
  return __builtin_elcore32_vfmaxred(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmaxred_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmaxred_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmaxred_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmaxred_mask(mask, s);
}

static __inline__ float __DEFAULT_FN_ATTRS
evx_vfmaxredr(
  v16f32_t s
)
{
  return __builtin_elcore32_vfmaxredr(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
evx_vfmaxredr_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmaxredr_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmin(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmin(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmin2(
  v16f32_t s
)
{
  return __builtin_elcore32_vfmin2(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmin2_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmin2_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmin2_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfmin2_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmin_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmin_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmin_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmin_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfminred(
  v16f32_t s
)
{
  return __builtin_elcore32_vfminred(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfminred_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfminred_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfminred_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfminred_mask(mask, s);
}

static __inline__ float __DEFAULT_FN_ATTRS
evx_vfminredr(
  v16f32_t s
)
{
  return __builtin_elcore32_vfminredr(s);
}

static __inline__ float __DEFAULT_FN_ATTRS
evx_vfminredr_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfminredr_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa12(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpa12(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa12_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpa12_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa12_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpa12_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa14(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpa14(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa14_def_mask(
  v16f32_t def, vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpa14_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa14_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpa14_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa22(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpa22(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa22_def_mask(
  v16f32_t def, vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpa22_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpa22_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpa22_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va0_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va0_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va0_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va0_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va10_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va10_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va10_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va10_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va11_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va11_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va11_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va11_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va12_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va12_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va12_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va12_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va13_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va13_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va13_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va13_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va14_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va14_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va14_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va14_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va15_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va15_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va15_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va15_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va1_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va1_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va1_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va1_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va2_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va2_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va2_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va2_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va3_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va3_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va3_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va3_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va4_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va4_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va4_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va4_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va5_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va5_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va5_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va5_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va6_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va6_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va6_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va6_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va7_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va7_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va7_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va7_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va8_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va8_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va8_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va8_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va9_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va9_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va9_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac12_va9_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac12_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va0_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va0_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va0_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va0_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va10_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va10_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va10_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va10_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va11_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va11_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va11_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va11_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va12_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va12_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va12_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va12_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va13_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va13_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va13_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va13_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va14_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va14_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va14_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va14_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va15_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va15_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va15_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va15_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va1_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va1_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va1_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va1_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va2_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va2_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va2_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va2_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va3_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va3_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va3_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va3_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va4_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va4_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va4_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va4_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va5_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va5_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va5_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va5_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va6_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va6_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va6_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va6_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va7_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va7_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va7_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va7_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va8_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va8_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va8_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va8_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va9_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va9_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va9_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac14_va9_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac14_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va0_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va0_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va0_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va0_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va10_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va10_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va10_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va10_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va11_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va11_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va11_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va11_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va12_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va12_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va12_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va12_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va13_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va13_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va13_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va13_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va14_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va14_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va14_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va14_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va15_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va15_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va15_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va15_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va1_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va1_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va1_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va1_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va2_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va2_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va2_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va2_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va3_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va3_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va3_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va3_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va4_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va4_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va4_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va4_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va5_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va5_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va5_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va5_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va6_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va6_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va6_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va6_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va7_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va7_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va7_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va7_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va8_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va8_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va8_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va8_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va9_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va9_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va9_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac22_va9_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac22_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va0_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va0_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va0_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va0_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va10_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va10_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va10_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va10_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va11_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va11_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va11_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va11_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va12_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va12_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va12_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va12_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va13_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va13_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va13_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va13_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va14_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va14_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va14_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va14_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va15_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va15_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va15_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va15_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va1_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va1_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va1_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va1_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va2_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va2_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va2_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va2_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va3_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va3_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va3_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va3_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va4_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va4_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va4_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va4_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va5_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va5_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va5_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va5_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va6_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va6_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va6_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va6_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va7_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va7_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va7_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va7_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va8_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va8_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va8_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va8_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va9_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va9_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va9_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac4_va9_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpac4_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va0_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va0_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va0_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va0_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va10_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va10_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va10_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va10_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va11_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va11_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va11_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va11_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va12_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va12_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va12_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va12_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va13_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va13_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va13_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va13_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va14_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va14_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va14_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va14_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va15_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va15_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va15_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va15_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va1_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va1_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va1_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va1_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va2_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va2_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va2_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va2_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va3_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va3_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va3_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va3_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va4_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va4_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va4_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va4_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va5_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va5_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va5_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va5_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va6_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va6_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va6_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va6_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va7_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va7_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va7_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va7_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va8_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va8_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va8_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va8_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va9_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va9_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va9_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpac_va9_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpac_va9_l8_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpar12_def(
  v16f32_t def, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpar12_def(def, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpar12_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpar12_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpar_def(
  v16f32_t def, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpar_def(def, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpar_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpar_def_mask(def, mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va0_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va0_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va0_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va0_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va10_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va10_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va10_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va10_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va11_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va11_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va11_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va11_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va12_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va12_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va12_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va12_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va13_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va13_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va13_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va13_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va14_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va14_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va14_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va14_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va15_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va15_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va15_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va15_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va1_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va1_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va1_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va1_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va2_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va2_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va2_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va2_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va3_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va3_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va3_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va3_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va4_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va4_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va4_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va4_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va5_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va5_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va5_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va5_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va6_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va6_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va6_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va6_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va7_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va7_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va7_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va7_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va8_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va8_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va8_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va8_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va9_l0(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va9_l0_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va9_l8(
  v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc4_va9_l8_mask(
  vp_t mask, v32f32_t s1, v32f32_t s2
)
{
  return __builtin_elcore32_vfmpsc4_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va0_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va0_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va0_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va0_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va10_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va10_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va10_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va10_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va11_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va11_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va11_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va11_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va12_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va12_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va12_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va12_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va13_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va13_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va13_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va13_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va14_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va14_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va14_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va14_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va15_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va15_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va15_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va15_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va1_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va1_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va1_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va1_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va2_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va2_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va2_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va2_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va3_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va3_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va3_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va3_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va4_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va4_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va4_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va4_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va5_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va5_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va5_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va5_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va6_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va6_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va6_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va6_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va7_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va7_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va7_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va7_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va8_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va8_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va8_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va8_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va9_l0(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va9_l0_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va9_l8(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmpsc_va9_l8_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsc_va9_l8_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpsr_def(
  v16f32_t def, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsr_def(def, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpsr_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpsr_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpy(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpy(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpy_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpy_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfmpy_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfmpy_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmx(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmx(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmx_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmx_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmx_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmx_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va0_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va0_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va0_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va0_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va10_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va10_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va10_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va10_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va11_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va11_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va11_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va11_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va12_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va12_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va12_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va12_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va13_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va13_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va13_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va13_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va14_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va14_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va14_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va14_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va15_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va15_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va15_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va15_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va1_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va1_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va1_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va1_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va2_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va2_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va2_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va2_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va3_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va3_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va3_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va3_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va4_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va4_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va4_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va4_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va5_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va5_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va5_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va5_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va6_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va6_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va6_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va6_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va7_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va7_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va7_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va7_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va8_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va8_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va8_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va8_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va9_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va9_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va9_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxac_va9_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxac_va9_l8_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxar_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxar_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxar_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxar_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxj(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxj(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxj_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxj_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxj_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxj_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va0_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va0_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va0_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va0_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va10_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va10_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va10_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va10_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va11_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va11_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va11_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va11_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va12_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va12_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va12_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va12_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va13_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va13_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va13_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va13_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va14_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va14_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va14_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va14_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va15_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va15_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va15_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va15_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va1_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va1_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va1_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va1_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va2_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va2_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va2_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va2_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va3_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va3_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va3_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va3_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va4_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va4_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va4_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va4_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va5_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va5_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va5_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va5_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va6_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va6_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va6_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va6_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va7_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va7_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va7_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va7_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va8_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va8_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va8_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va8_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va9_l0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va9_l0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va9_l8(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vfmxjac_va9_l8_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjac_va9_l8_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxjar_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjar_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vfmxjar_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vfmxjar_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfrec0(
  v16f32_t s
)
{
  return __builtin_elcore32_vfrec0(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfrec0_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfrec0_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfrec0_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfrec0_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfrecr0(
  v16f32_t s
)
{
  return __builtin_elcore32_vfrecr0(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfrecr0_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfrecr0_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfrecr0_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfrecr0_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfround(
  v16f32_t s
)
{
  return __builtin_elcore32_vfround(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfround_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfround_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfround_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vfround_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfsj(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfsj(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfsj_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfsj_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfsj_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfsj_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfsub(
  v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfsub(s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfsub_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfsub_def_mask(def, mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vfsub_mask(
  vp_t mask, v16f32_t s1, v16f32_t s2
)
{
  return __builtin_elcore32_vfsub_mask(mask, s1, s2);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vftrunc(
  v16f32_t s
)
{
  return __builtin_elcore32_vftrunc(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vftrunc_def_mask(
  v16f32_t def, vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vftrunc_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vftrunc_mask(
  vp_t mask, v16f32_t s
)
{
  return __builtin_elcore32_vftrunc_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhadd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhadd(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhadd4(
  v32i16_t s
)
{
  return __builtin_elcore32_vhadd4(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhadd4_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhadd4_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhadd4_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhadd4_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhadd_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhadd_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhadd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhadd_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhaj(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhaj(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhaj_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhaj_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhaj_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhaj_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhceil(
  v32i16_t s
)
{
  return __builtin_elcore32_vhceil(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhceil_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhceil_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhceil_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhceil_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhclass(
  v32i16_t s
)
{
  return __builtin_elcore32_vhclass(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhclass_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhclass_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhclass_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhclass_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvh(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_ceil(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_ceil(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_ceil_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_ceil_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_ceil_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_ceil_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_floor(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_floor(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_floor_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_floor_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_floor_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_floor_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_round(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_round(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_round_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_round_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_round_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_round_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_trunc(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_trunc(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_trunc_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_trunc_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvh_trunc_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvh_trunc_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_ceil(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_ceil(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_ceil_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_ceil_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_ceil_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_ceil_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_floor(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_floor(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_floor_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_floor_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_floor_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_floor_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_round(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_round(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_round_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_round_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_round_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_round_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_trunc(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_trunc(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_trunc_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_trunc_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhcvhu_trunc_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvhu_trunc_mask(mask, s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vhcvi(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcvi(s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vhcvi_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvi_def_mask(def, mask, s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vhcvi_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcvi_mask(mask, s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vhcviu(
  v32i16_t s
)
{
  return __builtin_elcore32_vhcviu(s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vhcviu_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcviu_def_mask(def, mask, s);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vhcviu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhcviu_mask(mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vhfcv(
  v32i16_t s
)
{
  return __builtin_elcore32_vhfcv(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vhfcv_def_mask(
  v32f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfcv_def_mask(def, mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vhfcv_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfcv_mask(mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vhfcvlin(
  v32i16_t s
)
{
  return __builtin_elcore32_vhfcvlin(s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vhfcvlin_def_mask(
  v32f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfcvlin_def_mask(def, mask, s);
}

static __inline__ v32f32_t __DEFAULT_FN_ATTRS
evx_vhfcvlin_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfcvlin_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfiltc14(
  v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vhfiltc14(s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfiltc14_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vhfiltc14_mask(mask, s1, s2, s3);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfiltc14e(
  v64i16_t s1, v64i16_t s2, v64i16_t s3
)
{
  return __builtin_elcore32_vhfiltc14e(s1, s2, s3);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfiltr14(
  v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vhfiltr14(s1, s2, s3);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfiltr14_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vhfiltr14_def_mask(def, mask, s1, s2, s3);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfiltr14_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3
)
{
  return __builtin_elcore32_vhfiltr14_mask(mask, s1, s2, s3);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfiltr22(
  v32i16_t s1, v32i16_t s2, v32i16_t s3, v32i16_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vhfiltr22(s1, s2, s3, s4, s5);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfiltr22_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3, v32i16_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vhfiltr22_def_mask(def, mask, s1, s2, s3, s4, s5);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfiltr22_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2, v32i16_t s3, v32i16_t s4, v32i16_t s5
)
{
  return __builtin_elcore32_vhfiltr22_mask(mask, s1, s2, s3, s4, s5);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfloor(
  v32i16_t s
)
{
  return __builtin_elcore32_vhfloor(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfloor_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfloor_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhfloor_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfloor_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vhfmax4(
  v32i16_t s
)
{
  return __builtin_elcore32_vhfmax4(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vhfmax4_def_mask(
  v16f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfmax4_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vhfmax4_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfmax4_mask(mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vhfmin4(
  v32i16_t s
)
{
  return __builtin_elcore32_vhfmin4(s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vhfmin4_def_mask(
  v16f32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfmin4_def_mask(def, mask, s);
}

static __inline__ v16f32_t __DEFAULT_FN_ATTRS
evx_vhfmin4_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhfmin4_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va0_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va0_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va0_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va0_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va10_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va10_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va10_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va10_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va11_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va11_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va11_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va11_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va12_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va12_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va12_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va12_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va13_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va13_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va13_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va13_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va14_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va14_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va14_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va14_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va15_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va15_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va15_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va15_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va1_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va1_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va1_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va1_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va2_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va2_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va2_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va2_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va3_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va3_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va3_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va3_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va4_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va4_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va4_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va4_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va5_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va5_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va5_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va5_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va6_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va6_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va6_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va6_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va7_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va7_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va7_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va7_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va8_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va8_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va8_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va8_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va9_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va9_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va9_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxac_va9_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxac_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va0_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va0_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va0_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va0_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va10_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va10_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va10_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va10_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va11_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va11_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va11_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va11_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va12_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va12_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va12_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va12_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va13_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va13_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va13_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va13_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va14_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va14_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va14_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va14_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va15_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va15_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va15_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va15_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va1_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va1_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va1_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va1_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va2_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va2_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va2_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va2_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va3_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va3_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va3_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va3_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va4_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va4_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va4_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va4_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va5_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va5_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va5_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va5_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va6_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va6_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va6_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va6_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va7_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va7_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va7_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va7_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va8_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va8_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va8_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va8_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va9_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va9_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va9_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhfmxjac_va9_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhfmxjac_va9_l8_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist0_def(
  v64i8_t def, v64i8_t s
)
{
  return __builtin_elcore32_vhist0_def(def, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist0_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhist0_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist1_def(
  v64i8_t def, v64i8_t s
)
{
  return __builtin_elcore32_vhist1_def(def, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist1_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhist1_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist2_def(
  v64i8_t def, v64i8_t s
)
{
  return __builtin_elcore32_vhist2_def(def, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist2_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhist2_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist3_def(
  v64i8_t def, v64i8_t s
)
{
  return __builtin_elcore32_vhist3_def(def, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vhist3_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhist3_def_mask(def, mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va0(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va0_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va1(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va10(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va10(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va10_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va10_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va11(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va11(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va11_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va11_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va12(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va12(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va12_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va12_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va13(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va13(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va13_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va13_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va14(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va14(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va14_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va14_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va15(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va15(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va15_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va15_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va1_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va2(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va2_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va2_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va3(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va3_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va3_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va4(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va4(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va4_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va4_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va5(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va5(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va5_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va5_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va6(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va6(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va6_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va6_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va7(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va7(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va7_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va7_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va8(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va8(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va8_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va8_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va9(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va9(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc0_va9_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc0_va9_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va0(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va0_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va1(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va10(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va10(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va10_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va10_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va11(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va11(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va11_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va11_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va12(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va12(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va12_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va12_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va13(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va13(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va13_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va13_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va14(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va14(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va14_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va14_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va15(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va15(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va15_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va15_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va1_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va2(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va2_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va2_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va3(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va3_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va3_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va4(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va4(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va4_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va4_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va5(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va5(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va5_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va5_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va6(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va6(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va6_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va6_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va7(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va7(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va7_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va7_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va8(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va8(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va8_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va8_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va9(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va9(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc1_va9_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc1_va9_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va0(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va0_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va1(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va10(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va10(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va10_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va10_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va11(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va11(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va11_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va11_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va12(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va12(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va12_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va12_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va13(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va13(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va13_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va13_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va14(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va14(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va14_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va14_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va15(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va15(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va15_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va15_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va1_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va2(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va2_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va2_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va3(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va3_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va3_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va4(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va4(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va4_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va4_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va5(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va5(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va5_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va5_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va6(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va6(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va6_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va6_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va7(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va7(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va7_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va7_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va8(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va8(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va8_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va8_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va9(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va9(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc2_va9_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc2_va9_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va0(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va0(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va0_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va1(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va1(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va10(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va10(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va10_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va10_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va11(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va11(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va11_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va11_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va12(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va12(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va12_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va12_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va13(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va13(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va13_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va13_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va14(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va14(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va14_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va14_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va15(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va15(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va15_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va15_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va1_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va2(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va2(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va2_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va2_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va3(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va3(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va3_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va3_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va4(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va4(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va4_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va4_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va5(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va5(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va5_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va5_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va6(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va6(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va6_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va6_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va7(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va7(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va7_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va7_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va8(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va8(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va8_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va8_mask(mask, s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va9(
  v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va9(s);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhistc3_va9_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vhistc3_va9_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmax(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmax(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmax4(
  v32i16_t s
)
{
  return __builtin_elcore32_vhmax4(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmax4_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhmax4_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmax4_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhmax4_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmax_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmax_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmax_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmax_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmin(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmin(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmin4(
  v32i16_t s
)
{
  return __builtin_elcore32_vhmin4(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmin4_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhmin4_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmin4_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhmin4_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmin_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmin_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmin_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmin_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpa14(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpa14(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpa14_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpa14_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpa14_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpa14_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpa22(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpa22(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpa22_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpa22_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpa22_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpa22_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va0_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va0_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va0_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va0_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va10_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va10_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va10_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va10_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va11_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va11_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va11_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va11_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va12_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va12_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va12_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va12_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va13_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va13_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va13_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va13_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va14_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va14_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va14_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va14_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va15_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va15_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va15_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va15_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va1_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va1_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va1_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va1_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va2_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va2_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va2_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va2_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va3_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va3_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va3_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va3_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va4_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va4_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va4_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va4_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va5_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va5_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va5_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va5_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va6_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va6_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va6_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va6_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va7_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va7_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va7_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va7_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va8_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va8_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va8_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va8_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va9_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va9_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va9_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac14_va9_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac14_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va0_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va0_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va0_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va0_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va10_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va10_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va10_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va10_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va11_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va11_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va11_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va11_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va12_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va12_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va12_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va12_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va13_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va13_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va13_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va13_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va14_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va14_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va14_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va14_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va15_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va15_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va15_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va15_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va1_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va1_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va1_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va1_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va2_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va2_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va2_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va2_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va3_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va3_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va3_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va3_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va4_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va4_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va4_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va4_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va5_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va5_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va5_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va5_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va6_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va6_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va6_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va6_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va7_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va7_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va7_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va7_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va8_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va8_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va8_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va8_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va9_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va9_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va9_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac22_va9_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac22_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va0_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va0_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va0_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va0_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va10_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va10_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va10_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va10_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va11_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va11_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va11_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va11_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va12_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va12_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va12_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va12_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va13_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va13_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va13_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va13_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va14_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va14_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va14_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va14_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va15_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va15_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va15_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va15_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va1_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va1_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va1_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va1_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va2_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va2_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va2_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va2_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va3_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va3_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va3_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va3_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va4_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va4_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va4_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va4_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va5_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va5_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va5_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va5_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va6_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va6_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va6_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va6_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va7_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va7_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va7_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va7_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va8_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va8_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va8_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va8_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va9_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va9_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va9_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpac_va9_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpac_va9_l8_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpar14_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpar14_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpar14_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpar14_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpar22_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpar22_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpar22_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpar22_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpar_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpar_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpar_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpar_def_mask(def, mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va0_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va0_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va0_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va0_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va10_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va10_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va10_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va10_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va11_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va11_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va11_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va11_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va12_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va12_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va12_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va12_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va13_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va13_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va13_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va13_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va14_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va14_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va14_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va14_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va15_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va15_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va15_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va15_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va1_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va1_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va1_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va1_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va2_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va2_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va2_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va2_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va3_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va3_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va3_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va3_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va4_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va4_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va4_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va4_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va5_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va5_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va5_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va5_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va6_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va6_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va6_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va6_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va7_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va7_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va7_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va7_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va8_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va8_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va8_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va8_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va9_l0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va9_l0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va9_l8(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vhmpsc_va9_l8_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsc_va9_l8_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpsr_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsr_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpsr_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpsr_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpy(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpy(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpy_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpy_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmpy_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmpy_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmx(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmx(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmx_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmx_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmx_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmx_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxar_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxar_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxar_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxar_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxj(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxj(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxj_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxj_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxj_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxj_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxjar_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxjar_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhmxjar_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhmxjar_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhround(
  v32i16_t s
)
{
  return __builtin_elcore32_vhround(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhround_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhround_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhround_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhround_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhsj(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhsj(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhsj_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhsj_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhsj_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhsj_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhsub(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhsub(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhsub_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhsub_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhsub_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vhsub_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhtrunc(
  v32i16_t s
)
{
  return __builtin_elcore32_vhtrunc(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhtrunc_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhtrunc_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vhtrunc_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vhtrunc_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vindexb(
  int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_vindexb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vindexb_def_mask(
  v64i8_t def, vp_t mask, int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_vindexb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vindexb_mask(
  vp_t mask, int8_t s1, int8_t s2
)
{
  return __builtin_elcore32_vindexb_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vindexd(
  int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_vindexd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vindexd_def_mask(
  v8i64_t def, vp_t mask, int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_vindexd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vindexd_mask(
  vp_t mask, int64_t s1, int64_t s2
)
{
  return __builtin_elcore32_vindexd_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vindexh(
  int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_vindexh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vindexh_def_mask(
  v32i16_t def, vp_t mask, int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_vindexh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vindexh_mask(
  vp_t mask, int16_t s1, int16_t s2
)
{
  return __builtin_elcore32_vindexh_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vindexl(
  int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_vindexl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vindexl_def_mask(
  v16i32_t def, vp_t mask, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_vindexl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vindexl_mask(
  vp_t mask, int32_t s1, int32_t s2
)
{
  return __builtin_elcore32_vindexl_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vins_def(
  v64i8_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vins_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vins_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vins_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vinteb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vinteb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vinteb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vinteb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vinteb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vinteb_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vinted_def(
  v8i64_t def, v8i64_t s
)
{
  return __builtin_elcore32_vinted_def(def, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vinted_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vinted_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vinteh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vinteh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vinteh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vinteh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vinteh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vinteh_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vinteq_def(
  v8i64_t def, v8i64_t s
)
{
  return __builtin_elcore32_vinteq_def(def, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vinteq_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vinteq_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintey_def(
  v8i64_t def, v8i64_t s
)
{
  return __builtin_elcore32_vintey_def(def, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintey_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vintey_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vintob(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vintob(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vintob_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vintob_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vintob_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vintob_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintod_def(
  v8i64_t def, v8i64_t s
)
{
  return __builtin_elcore32_vintod_def(def, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintod_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vintod_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vintoh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vintoh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vintoh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vintoh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vintoh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vintoh_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintoq_def(
  v8i64_t def, v8i64_t s
)
{
  return __builtin_elcore32_vintoq_def(def, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintoq_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vintoq_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintoy_def(
  v8i64_t def, v8i64_t s
)
{
  return __builtin_elcore32_vintoy_def(def, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vintoy_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vintoy_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld(
  void * addr
)
{
  return __builtin_elcore32_vld(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu(
  void * addr
)
{
  return __builtin_elcore32_vld3blu(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3blu_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vld3blu_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld3blu_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld3blu_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld3blu_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vld3blu_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vld3blu_mask(mask, addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu(
  void * addr
)
{
  return __builtin_elcore32_vld3hdu(addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_ami(addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_ami_def_mask(
  v8i64_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_ami_mask(mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_api(addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_api_def_mask(
  v8i64_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_api_def_mask(def, mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_api_mask(mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_appi(addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_appi_def_mask(
  v8i64_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld3hdu_appi_mask(mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_def_mask(
  v8i64_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vld3hdu_def_mask(def, mask, addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld3hdu_e32(imm_addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_e32_def_mask(
  v8i64_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld3hdu_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld3hdu_e32_mask(mask, imm_addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld3hdu_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vld3hdu_mask(mask, addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_ami(addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_ami_def_mask(
  v8i64_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_ami_mask(mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_api(addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_api_def_mask(
  v8i64_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_api_def_mask(def, mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_api_mask(mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_appi(addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_appi_def_mask(
  v8i64_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vld_appi_mask(mask, addr, offset);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_def_mask(
  v8i64_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vld_def_mask(def, mask, addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld_e32(imm_addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_e32_def_mask(
  v8i64_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vld_e32_mask(mask, imm_addr);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vld_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vld_mask(mask, addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh(
  void * addr
)
{
  return __builtin_elcore32_vldbh(addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_ami(addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_ami_def_mask(
  v32i16_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_ami_mask(mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_api(addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_api_def_mask(
  v32i16_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_api_def_mask(def, mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_api_mask(mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_appi(addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_appi_def_mask(
  v32i16_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbh_appi_mask(mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_def_mask(
  v32i16_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldbh_def_mask(def, mask, addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbh_e32(imm_addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_e32_def_mask(
  v32i16_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbh_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbh_e32_mask(mask, imm_addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbh_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldbh_mask(mask, addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu(
  void * addr
)
{
  return __builtin_elcore32_vldbhu(addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_ami(addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_ami_def_mask(
  v32i16_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_ami_mask(mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_api(addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_api_def_mask(
  v32i16_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_api_def_mask(def, mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_api_mask(mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_appi(addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_appi_def_mask(
  v32i16_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbhu_appi_mask(mask, addr, offset);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_def_mask(
  v32i16_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldbhu_def_mask(def, mask, addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbhu_e32(imm_addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_e32_def_mask(
  v32i16_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbhu_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbhu_e32_mask(mask, imm_addr);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vldbhu_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldbhu_mask(mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl(
  void * addr
)
{
  return __builtin_elcore32_vldbl(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldbl_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldbl_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbl_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbl_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldbl_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldbl_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldbl_mask(mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu(
  void * addr
)
{
  return __builtin_elcore32_vldblu(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldblu_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldblu_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldblu_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldblu_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldblu_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldblu_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldblu_mask(mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl(
  void * addr
)
{
  return __builtin_elcore32_vldhl(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhl_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldhl_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldhl_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldhl_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldhl_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhl_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldhl_mask(mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu(
  void * addr
)
{
  return __builtin_elcore32_vldhlu(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldhlu_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldhlu_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldhlu_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldhlu_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldhlu_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldhlu_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldhlu_mask(mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld(
  void * addr
)
{
  return __builtin_elcore32_vldld(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldld_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldld_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldld_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldld_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldld_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldld_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldld_mask(mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu(
  void * addr
)
{
  return __builtin_elcore32_vldldu(addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_ami(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_ami(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_ami_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_ami_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_ami_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_ami_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_api(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_api(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_api_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_api_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_api_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_api_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_appi(
  void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_appi(addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_appi_def_mask(
  v16i32_t def, vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_appi_def_mask(def, mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_appi_mask(
  vp_t mask, void * addr, int32_t offset
)
{
  return __builtin_elcore32_vldldu_appi_mask(mask, addr, offset);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_def_mask(
  v16i32_t def, vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldldu_def_mask(def, mask, addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_e32(
  const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldldu_e32(imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_e32_def_mask(
  v16i32_t def, vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldldu_e32_def_mask(def, mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_e32_mask(
  vp_t mask, const uint32_t imm_addr
) __attribute__((
  enable_if((0 <= imm_addr && imm_addr <= 4294967295),
            "imm_addr must be IMM: [0...4294967295]")
))
{
  return __builtin_elcore32_vldldu_e32_mask(mask, imm_addr);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vldldu_mask(
  vp_t mask, void * addr
)
{
  return __builtin_elcore32_vldldu_mask(mask, addr);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpk3blu(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpk3blu(s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpk3blu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpk3blu_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpk3blu_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpk3blu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpk3hdu(
  v32i16_t s
)
{
  return __builtin_elcore32_vlinpk3hdu(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpk3hdu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpk3hdu_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpk3hdu_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpk3hdu_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbh0(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbh0(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbh0_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbh0_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbh0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbh0_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbh1(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbh1(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbh1_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbh1_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbh1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbh1_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbhu0(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbhu0(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbhu0_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbhu0_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbhu0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbhu0_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbhu1(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbhu1(s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbhu1_def_mask(
  v32i16_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbhu1_def_mask(def, mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkbhu1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbhu1_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl0(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl0(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl0_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl0_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl0_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl1(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl1(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl1_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl1_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl1_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl2(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl2(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl2_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl2_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl2_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl2_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl3(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl3(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl3_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl3_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkbl3_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkbl3_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu0(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu0(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu0_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu0_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu0_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu0_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu1(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu1(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu1_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu1_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu1_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu1_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu2(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu2(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu2_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu2_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu2_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu2_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu3(
  v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu3(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu3_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu3_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkblu3_mask(
  vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkblu3_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkd3hu_def(
  v32i16_t def, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkd3hu_def(def, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpkd3hu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkd3hu_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdl(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdl_def_mask(
  v16i32_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdl_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdlu(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdlu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdlu_def_mask(
  v16i32_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdlu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdlu_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdlu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdlu_trunc(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdlu_trunc(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdlu_trunc_def_mask(
  v16i32_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdlu_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkdlu_trunc_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlinpkdlu_trunc_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhb(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhb_def_mask(
  v64i8_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhb_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhbu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhbu_def_mask(
  v64i8_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhbu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhbu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhbu_trunc(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhbu_trunc(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhbu_trunc_def_mask(
  v64i8_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhbu_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkhbu_trunc_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlinpkhbu_trunc_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhl0(
  v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhl0(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhl0_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhl0_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhl0_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhl0_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhl1(
  v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhl1(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhl1_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhl1_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhl1_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhl1_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhlu0(
  v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhlu0(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhlu0_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhlu0_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhlu0_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhlu0_mask(mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhlu1(
  v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhlu1(s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhlu1_def_mask(
  v16i32_t def, vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhlu1_def_mask(def, mask, s);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlinpkhlu1_mask(
  vp_t mask, v32i16_t s
)
{
  return __builtin_elcore32_vlinpkhlu1_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkl3bu_def(
  v64i8_t def, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkl3bu_def(def, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpkl3bu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s
)
{
  return __builtin_elcore32_vlinpkl3bu_def_mask(def, mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklb0_def(
  v64i8_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklb0_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklb0_def_mask(
  v64i8_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklb0_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklb1_def(
  v64i8_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklb1_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklb1_def_mask(
  v64i8_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklb1_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklbu0_def(
  v64i8_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklbu0_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklbu0_def_mask(
  v64i8_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklbu0_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklbu0_trunc_def(
  v64i8_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklbu0_trunc_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklbu0_trunc_def_mask(
  v64i8_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklbu0_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklbu1_def(
  v64i8_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklbu1_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlinpklbu1_def_mask(
  v64i8_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklbu1_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkld0(
  v16i32_t s
)
{
  return __builtin_elcore32_vlinpkld0(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkld0_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkld0_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkld0_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkld0_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkld1(
  v16i32_t s
)
{
  return __builtin_elcore32_vlinpkld1(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkld1_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkld1_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkld1_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkld1_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkldu0(
  v16i32_t s
)
{
  return __builtin_elcore32_vlinpkldu0(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkldu0_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkldu0_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkldu0_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkldu0_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkldu1(
  v16i32_t s
)
{
  return __builtin_elcore32_vlinpkldu1(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkldu1_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkldu1_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlinpkldu1_mask(
  vp_t mask, v16i32_t s
)
{
  return __builtin_elcore32_vlinpkldu1_mask(mask, s);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklh(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklh_def_mask(
  v32i16_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklh_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklhu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklhu_def_mask(
  v32i16_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklhu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklhu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklhu_trunc(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklhu_trunc(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklhu_trunc_def_mask(
  v32i16_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklhu_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlinpklhu_trunc_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlinpklhu_trunc_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlslb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlslb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlslb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlslb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlslb_def_mask_i(
  v64i8_t def, vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlslb_def_mask_i(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlslb_i(
  const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlslb_i(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlslb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlslb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlslb_mask_i(
  vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlslb_mask_i(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsld(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsld(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsld_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsld_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsld_def_mask_i(
  v8i64_t def, vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsld_def_mask_i(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsld_i(
  const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsld_i(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsld_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsld_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsld_mask_i(
  vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsld_mask_i(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlslh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlslh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlslh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlslh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlslh_def_mask_i(
  v32i16_t def, vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlslh_def_mask_i(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlslh_i(
  const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlslh_i(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlslh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlslh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlslh_mask_i(
  vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlslh_mask_i(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsll(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsll(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsll_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsll_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsll_def_mask_i(
  v16i32_t def, vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsll_def_mask_i(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsll_i(
  const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsll_i(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsll_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsll_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsll_mask_i(
  vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsll_mask_i(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlsrb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlsrb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_def_mask_i(
  v64i8_t def, vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrb_def_mask_i(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_i(
  const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrb_i(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlsrb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_mask_i(
  vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrb_mask_i(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_rnd(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlsrb_rnd(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_rnd_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlsrb_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_rnd_def_mask_i(
  v64i8_t def, vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrb_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_rnd_i(
  const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrb_rnd_i(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_rnd_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vlsrb_rnd_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlsrb_rnd_mask_i(
  vp_t mask, const uint8_t s1, v64i8_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrb_rnd_mask_i(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsrd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsrd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_def_mask_i(
  v8i64_t def, vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_i(
  const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrd_i(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsrd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_mask_i(
  vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrd_mask_i(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_rnd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsrd_rnd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_rnd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsrd_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_rnd_def_mask_i(
  v8i64_t def, vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrd_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_rnd_i(
  const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrd_rnd_i(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_rnd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vlsrd_rnd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vlsrd_rnd_mask_i(
  vp_t mask, const uint8_t s1, v8i64_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrd_rnd_mask_i(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlsrh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlsrh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_def_mask_i(
  v32i16_t def, vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrh_def_mask_i(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_i(
  const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrh_i(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlsrh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_mask_i(
  vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrh_mask_i(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_rnd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlsrh_rnd(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_rnd_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlsrh_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_rnd_def_mask_i(
  v32i16_t def, vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrh_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_rnd_i(
  const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrh_rnd_i(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_rnd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vlsrh_rnd_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vlsrh_rnd_mask_i(
  vp_t mask, const uint8_t s1, v32i16_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrh_rnd_mask_i(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsrl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsrl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_def_mask_i(
  v16i32_t def, vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrl_def_mask_i(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_i(
  const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrl_i(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsrl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_mask_i(
  vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrl_mask_i(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_rnd(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsrl_rnd(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_rnd_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsrl_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_rnd_def_mask_i(
  v16i32_t def, vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrl_rnd_def_mask_i(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_rnd_i(
  const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrl_rnd_i(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_rnd_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vlsrl_rnd_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vlsrl_rnd_mask_i(
  vp_t mask, const uint8_t s1, v16i32_t s2
) __attribute__((
  enable_if((0 <= s1 && s1 <= 31),
            "s1 must be IMM: [0...31]")
))
{
  return __builtin_elcore32_vlsrl_rnd_mask_i(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlut0_def(
  v64i8_t def, v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vlut0_def(def, s1, s2, s3);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vlut1_def(
  v64i8_t def, v64i8_t s1, v64i8_t s2, v64i8_t s3
)
{
  return __builtin_elcore32_vlut1_def(def, s1, s2, s3);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmax2l(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmax2l(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmax2l_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmax2l_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmax2l_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmax2l_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmax2lu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmax2lu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmax2lu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmax2lu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmax2lu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmax2lu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmax4h(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmax4h(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmax4h_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmax4h_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmax4h_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmax4h_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmax4hu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmax4hu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmax4hu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmax4hu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmax4hu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmax4hu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmax8b(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmax8b(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmax8b_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmax8b_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmax8b_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmax8b_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmax8bu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmax8bu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmax8bu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmax8bu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmax8bu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmax8bu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmaxb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmaxb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmaxb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmaxb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmaxb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmaxb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmaxbu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmaxbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmaxbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmaxbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmaxbu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmaxbu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxd(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmaxd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmaxd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxd_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmaxd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxdu(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmaxdu(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxdu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmaxdu_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxdu_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmaxdu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmaxh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmaxh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmaxh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmaxh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmaxh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmaxh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmaxhu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmaxhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmaxhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmaxhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmaxhu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmaxhu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmaxl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmaxl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmaxl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmaxl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmaxl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmaxl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmaxlu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmaxlu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmaxlu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmaxlu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmaxlu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmaxlu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxredd(
  v8i64_t s
)
{
  return __builtin_elcore32_vmaxredd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxredd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vmaxredd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxredd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vmaxredd_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxreddu(
  v8i64_t s
)
{
  return __builtin_elcore32_vmaxreddu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxreddu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vmaxreddu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmaxreddu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vmaxreddu_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vmaxredrd(
  v8i64_t s
)
{
  return __builtin_elcore32_vmaxredrd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vmaxredrd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vmaxredrd_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vmaxredrdu(
  v8i64_t s
)
{
  return __builtin_elcore32_vmaxredrdu(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vmaxredrdu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vmaxredrdu_mask(mask, s);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa14bhb(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14bhb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa14bhb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14bhb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa14bhb_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14bhb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa14bhbu(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14bhbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa14bhbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14bhbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa14bhbu_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14bhbu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa14hhh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14hhh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa14hhh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14hhh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa14hhh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14hhh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa14hhhu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14hhhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa14hhhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14hhhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa14hhhu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa14hhhu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa22bhb(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22bhb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa22bhb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22bhb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa22bhb_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22bhb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa22bhbu(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22bhbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa22bhbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22bhbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfa22bhbu_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22bhbu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa22hhh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22hhh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa22hhh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22hhh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa22hhh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22hhh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa22hhhu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22hhhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa22hhhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22hhhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfa22hhhu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfa22hhhu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfarbhb_def(
  v64i8_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarbhb_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfarbhb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarbhb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfarbhbu_def(
  v64i8_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarbhbu_def(def, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmfarbhbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarbhbu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfarhhh_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarhhh_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfarhhh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarhhh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfarhhh_floor_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarhhh_floor_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfarhhh_floor_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarhhh_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfarhhhu_def(
  v32i16_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarhhhu_def(def, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfarhhhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfarhhhu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfarlll_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfarlll_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfarlll_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfarlll_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfarlll_floor_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfarlll_floor_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfarlll_floor_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfarlll_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfarlllu_def(
  v16i32_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfarlllu_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfarlllu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfarlllu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfxh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfxh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfxh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfxh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfxh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfxh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfxjh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfxjh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfxjh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfxjh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmfxjh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmfxjh_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfxjl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfxjl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfxjl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfxjl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfxjl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfxjl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfxl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfxl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfxl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfxl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmfxl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmfxl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmin2l(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmin2l(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmin2l_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmin2l_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmin2l_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmin2l_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmin2lu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmin2lu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmin2lu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmin2lu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmin2lu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmin2lu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmin4h(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmin4h(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmin4h_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmin4h_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmin4h_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmin4h_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmin4hu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmin4hu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmin4hu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmin4hu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmin4hu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmin4hu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmin8b(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmin8b(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmin8b_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmin8b_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmin8b_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmin8b_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmin8bu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmin8bu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmin8bu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmin8bu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmin8bu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmin8bu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vminb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vminb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vminb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vminb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vminb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vminb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vminbu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vminbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vminbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vminbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vminbu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vminbu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmind(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmind(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmind_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmind_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmind_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmind_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmindu(
  v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmindu(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmindu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmindu_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmindu_mask(
  vp_t mask, v8i64_t s1, v8i64_t s2
)
{
  return __builtin_elcore32_vmindu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vminh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vminh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vminh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vminh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vminh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vminh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vminhu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vminhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vminhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vminhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vminhu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vminhu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vminl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vminl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vminl_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vminl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vminl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vminl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vminlu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vminlu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vminlu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vminlu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vminlu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vminlu_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vminredd(
  v8i64_t s
)
{
  return __builtin_elcore32_vminredd(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vminredd_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vminredd_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vminredd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vminredd_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vminreddu(
  v8i64_t s
)
{
  return __builtin_elcore32_vminreddu(s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vminreddu_def_mask(
  v8i64_t def, vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vminreddu_def_mask(def, mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vminreddu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vminreddu_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vminredrd(
  v8i64_t s
)
{
  return __builtin_elcore32_vminredrd(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vminredrd_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vminredrd_mask(mask, s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vminredrdu(
  v8i64_t s
)
{
  return __builtin_elcore32_vminredrdu(s);
}

static __inline__ int64_t __DEFAULT_FN_ATTRS
evx_vminredrdu_mask(
  vp_t mask, v8i64_t s
)
{
  return __builtin_elcore32_vminredrdu_mask(mask, s);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa12lld(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpa12lld(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa12lld_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpa12lld_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa12lld_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpa12lld_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa14bhl(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14bhl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa14bhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14bhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa14bhl_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14bhl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa14buhl(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14buhl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa14buhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14buhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa14buhl_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14buhl_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa14hhd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14hhd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa14hhd_def_mask(
  v8i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14hhd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa14hhd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14hhd_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa14huhd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14huhd(s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa14huhd_def_mask(
  v8i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14huhd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpa14huhd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa14huhd_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa18bbl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa18bbl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa18bbl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa18bbl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa18bbl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa18bbl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa18bubl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa18bubl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa18bubl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa18bubl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa18bubl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa18bubl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa22bhl(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22bhl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa22bhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22bhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa22bhl_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22bhl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa22buhl(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22buhl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa22buhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22buhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa22buhl_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22buhl_mask(mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpa22hhd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22hhd(s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpa22hhd_def_mask(
  v16i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22hhd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpa22hhd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22hhd_mask(mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpa22huhd(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22huhd(s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpa22huhd_def_mask(
  v16i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22huhd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpa22huhd_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpa22huhd_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa24bbl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa24bbl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa24bbl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa24bbl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa24bbl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa24bbl_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa24bubl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa24bubl(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa24bubl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa24bubl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpa24bubl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa24bubl_mask(mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpa42bbl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa42bbl(s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpa42bbl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa42bbl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpa42bbl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa42bbl_mask(mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpa42bubl(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa42bubl(s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpa42bubl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa42bubl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpa42bubl_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpa42bubl_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va0_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va0_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va0_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va0_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va10_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va10_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va10_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va10_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va11_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va11_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va11_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va11_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va12_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va12_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va12_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va12_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va13_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va13_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va13_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va13_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va14_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va14_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va14_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va14_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va15_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va15_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va15_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va15_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va1_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va1_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va1_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va1_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va2_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va2_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va2_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va2_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va3_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va3_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va3_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va3_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va4_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va4_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va4_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va4_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va5_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va5_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va5_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va5_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va6_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va6_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va6_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va6_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va7_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va7_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va7_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va7_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va8_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va8_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va8_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va8_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va9_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va9_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va9_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac12ll_va9_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpac12ll_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va0_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va0_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va0_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va0_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va10_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va10_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va10_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va10_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va11_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va11_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va11_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va11_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va12_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va12_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va12_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va12_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va13_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va13_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va13_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va13_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va14_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va14_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va14_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va14_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va15_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va15_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va15_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va15_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va1_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va1_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va1_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va1_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va2_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va2_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va2_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va2_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va3_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va3_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va3_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va3_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va4_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va4_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va4_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va4_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va5_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va5_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va5_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va5_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va6_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va6_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va6_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va6_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va7_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va7_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va7_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va7_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va8_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va8_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va8_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va8_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va9_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va9_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va9_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14bh_va9_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14bh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va0_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va0_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va0_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va0_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va10_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va10_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va10_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va10_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va11_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va11_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va11_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va11_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va12_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va12_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va12_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va12_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va13_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va13_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va13_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va13_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va14_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va14_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va14_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va14_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va15_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va15_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va15_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va15_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va1_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va1_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va1_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va1_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va2_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va2_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va2_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va2_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va3_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va3_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va3_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va3_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va4_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va4_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va4_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va4_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va5_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va5_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va5_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va5_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va6_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va6_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va6_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va6_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va7_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va7_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va7_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va7_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va8_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va8_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va8_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va8_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va9_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va9_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va9_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14buh_va9_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14buh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14hh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14hh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac14huh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac14huh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bb_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bb_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac18bub_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac18bub_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va0_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va0_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va0_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va0_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va10_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va10_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va10_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va10_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va11_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va11_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va11_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va11_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va12_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va12_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va12_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va12_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va13_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va13_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va13_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va13_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va14_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va14_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va14_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va14_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va15_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va15_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va15_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va15_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va1_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va1_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va1_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va1_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va2_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va2_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va2_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va2_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va3_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va3_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va3_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va3_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va4_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va4_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va4_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va4_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va5_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va5_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va5_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va5_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va6_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va6_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va6_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va6_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va7_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va7_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va7_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va7_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va8_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va8_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va8_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va8_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va9_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va9_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va9_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22bh_va9_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22bh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va0_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va0_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va0_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va0_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va10_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va10_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va10_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va10_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va11_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va11_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va11_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va11_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va12_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va12_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va12_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va12_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va13_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va13_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va13_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va13_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va14_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va14_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va14_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va14_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va15_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va15_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va15_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va15_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va1_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va1_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va1_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va1_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va2_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va2_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va2_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va2_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va3_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va3_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va3_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va3_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va4_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va4_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va4_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va4_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va5_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va5_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va5_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va5_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va6_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va6_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va6_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va6_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va7_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va7_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va7_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va7_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va8_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va8_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va8_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va8_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va9_d0(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va9_d0_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va9_d4(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22buh_va9_d4_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22buh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22hh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22hh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac22huh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpac22huh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bb_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bb_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac24bub_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac24bub_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bb_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bb_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpac42bub_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpac42bub_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbb_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbb_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbub_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpacbub_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacbuh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpacbuh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpachuh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpachuh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va0_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va0_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va0_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va0_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va10_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va10_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va10_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va10_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va11_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va11_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va11_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va11_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va12_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va12_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va12_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va12_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va13_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va13_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va13_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va13_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va14_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va14_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va14_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va14_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va15_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va15_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va15_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va15_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va1_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va1_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va1_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va1_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va2_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va2_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va2_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va2_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va3_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va3_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va3_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va3_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va4_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va4_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va4_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va4_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va5_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va5_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va5_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va5_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va6_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va6_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va6_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va6_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va7_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va7_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va7_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va7_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va8_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va8_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va8_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va8_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va9_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va9_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va9_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpacll_va9_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpacll_va9_d4_mask(mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpar12lld_def(
  v8i64_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpar12lld_def(def, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpar12lld_def_mask(
  v8i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpar12lld_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar14bhl_def(
  v16i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14bhl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar14bhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14bhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar14buhl_def(
  v16i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14buhl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar14buhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14buhl_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpar14hhd_def(
  v8i64_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14hhd_def(def, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpar14hhd_def_mask(
  v8i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14hhd_def_mask(def, mask, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpar14huhd_def(
  v8i64_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14huhd_def(def, s1, s2);
}

static __inline__ v8i64_t __DEFAULT_FN_ATTRS
evx_vmpar14huhd_def_mask(
  v8i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar14huhd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar18bbl_def(
  v16i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar18bbl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar18bbl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar18bbl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar18bubl_def(
  v16i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar18bubl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar18bubl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar18bubl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar22bhl_def(
  v16i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22bhl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar22bhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22bhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar22buhl_def(
  v16i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22buhl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar22buhl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22buhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpar22hhd_def(
  v16i64_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22hhd_def(def, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpar22hhd_def_mask(
  v16i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22hhd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpar22huhd_def(
  v16i64_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22huhd_def(def, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpar22huhd_def_mask(
  v16i64_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpar22huhd_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar24bbl_def(
  v16i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar24bbl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar24bbl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar24bbl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar24bubl_def(
  v16i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar24bubl_def(def, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpar24bubl_def_mask(
  v16i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar24bubl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpar42bbl_def(
  v32i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar42bbl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpar42bbl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar42bbl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpar42bubl_def(
  v32i32_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar42bubl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpar42bubl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpar42bubl_def_mask(def, mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmparbbh_def(
  v64i16_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmparbbh_def(def, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmparbbh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmparbbh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparbhl_def(
  v32i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparbhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparbhl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparbhl_def_mask(def, mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmparbubh_def(
  v64i16_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmparbubh_def(def, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmparbubh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmparbubh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparbuhl_def(
  v32i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparbuhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparbuhl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparbuhl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparhhl_def(
  v32i32_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparhhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparhhl_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparhhl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparhuhl_def(
  v32i32_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparhuhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmparhuhl_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmparhuhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmparlld_def(
  v16i64_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmparlld_def(def, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmparlld_def_mask(
  v16i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmparlld_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbbb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpfbbb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbbb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpfbbb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbbb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpfbbb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbbbu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpfbbbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbbbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpfbbbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbbbu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpfbbbu_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbhb(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfbhb(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbhb_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfbhb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbhb_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfbhb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbhbu(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfbhbu(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbhbu_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfbhbu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpfbhbu_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfbhbu_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_floor(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_floor(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_floor_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_floor_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_floor_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_trunc(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_trunc(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_trunc_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhh_trunc_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhh_trunc_mask(mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhhu(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhhu(s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhhu_def_mask(
  v32i16_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhhu_def_mask(def, mask, s1, s2);
}

static __inline__ v32i16_t __DEFAULT_FN_ATTRS
evx_vmpfhhhu_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpfhhhu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpfhlh(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpfhlh(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpfhlh_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpfhlh_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpfhlh_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpfhlh_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpfhlhu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpfhlhu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpfhlhu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpfhlhu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpfhlhu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpfhlhu_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_floor(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_floor(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_floor_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_floor_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_floor_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_floor_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_trunc(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_trunc(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_trunc_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_trunc_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflll_trunc_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflll_trunc_mask(mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflllu(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflllu(s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflllu_def_mask(
  v16i32_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflllu_def_mask(def, mask, s1, s2);
}

static __inline__ v16i32_t __DEFAULT_FN_ATTRS
evx_vmpflllu_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpflllu_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbb_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbb_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va0_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va0_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va0_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va0_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va0_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va0_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va0_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va0_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va10_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va10_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va10_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va10_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va10_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va10_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va10_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va10_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va11_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va11_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va11_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va11_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va11_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va11_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va11_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va11_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va12_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va12_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va12_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va12_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va12_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va12_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va12_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va12_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va13_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va13_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va13_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va13_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va13_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va13_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va13_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va13_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va14_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va14_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va14_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va14_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va14_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va14_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va14_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va14_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va15_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va15_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va15_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va15_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va15_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va15_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va15_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va15_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va1_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va1_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va1_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va1_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va1_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va1_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va1_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va1_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va2_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va2_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va2_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va2_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va2_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va2_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va2_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va2_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va3_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va3_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va3_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va3_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va3_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va3_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va3_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va3_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va4_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va4_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va4_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va4_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va4_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va4_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va4_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va4_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va5_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va5_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va5_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va5_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va5_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va5_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va5_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va5_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va6_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va6_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va6_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va6_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va6_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va6_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va6_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va6_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va7_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va7_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va7_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va7_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va7_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va7_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va7_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va7_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va8_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va8_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va8_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va8_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va8_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va8_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va8_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va8_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va9_l0(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va9_l0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va9_l0_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va9_l0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va9_l8(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va9_l8(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbub_va9_l8_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpscbub_va9_l8_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscbuh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpscbuh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va0_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va0_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va0_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va0_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va10_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va10_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va10_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va10_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va11_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va11_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va11_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va11_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va12_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va12_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va12_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va12_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va13_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va13_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va13_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va13_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va14_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va14_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va14_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va14_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va15_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va15_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va15_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va15_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va1_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va1_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va1_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va1_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va2_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va2_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va2_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va2_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va3_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va3_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va3_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va3_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va4_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va4_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va4_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va4_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va5_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va5_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va5_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va5_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va6_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va6_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va6_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va6_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va7_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va7_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va7_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va7_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va8_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va8_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va8_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va8_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va9_d0(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va9_d0_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va9_d4(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpschuh_va9_d4_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpschuh_va9_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va0_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va0_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va0_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va0_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va0_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va0_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va0_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va0_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va10_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va10_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va10_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va10_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va10_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va10_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va10_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va10_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va11_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va11_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va11_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va11_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va11_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va11_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va11_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va11_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va12_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va12_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va12_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va12_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va12_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va12_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va12_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va12_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va13_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va13_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va13_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va13_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va13_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va13_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va13_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va13_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va14_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va14_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va14_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va14_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va14_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va14_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va14_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va14_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va15_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va15_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va15_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va15_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va15_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va15_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va15_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va15_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va1_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va1_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va1_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va1_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va1_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va1_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va1_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va1_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va2_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va2_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va2_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va2_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va2_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va2_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va2_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va2_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va3_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va3_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va3_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va3_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va3_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va3_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va3_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va3_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va4_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va4_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va4_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va4_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va4_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va4_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va4_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va4_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va5_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va5_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va5_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va5_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va5_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va5_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va5_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va5_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va6_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va6_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va6_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va6_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va6_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va6_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va6_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va6_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va7_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va7_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va7_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va7_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va7_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va7_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va7_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va7_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va8_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va8_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va8_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va8_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va8_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va8_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va8_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va8_d4_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va9_d0(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va9_d0(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va9_d0_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va9_d0_mask(mask, s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va9_d4(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va9_d4(s1, s2);
}

static __inline__ void __DEFAULT_FN_ATTRS
evx_vmpscll_va9_d4_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpscll_va9_d4_mask(mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpsrbbh_def(
  v64i16_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpsrbbh_def(def, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpsrbbh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpsrbbh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrbhl_def(
  v32i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrbhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrbhl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrbhl_def_mask(def, mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpsrbubh_def(
  v64i16_t def, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpsrbubh_def(def, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpsrbubh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpsrbubh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrbuhl_def(
  v32i32_t def, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrbuhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrbuhl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrbuhl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrhhl_def(
  v32i32_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrhhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrhhl_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrhhl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrhuhl_def(
  v32i32_t def, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrhuhl_def(def, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpsrhuhl_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpsrhuhl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpsrlld_def(
  v16i64_t def, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpsrlld_def(def, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpsrlld_def_mask(
  v16i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpsrlld_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpxh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpxh(s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpxh_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpxh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpxh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpxh_mask(mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpxjh(
  v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpxjh(s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpxjh_def_mask(
  v32i32_t def, vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpxjh_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpxjh_mask(
  vp_t mask, v32i16_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpxjh_mask(mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpxjl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpxjl(s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpxjl_def_mask(
  v16i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpxjl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpxjl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpxjl_mask(mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpxl(
  v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpxl(s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpxl_def_mask(
  v16i64_t def, vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpxl_def_mask(def, mask, s1, s2);
}

static __inline__ v16i64_t __DEFAULT_FN_ATTRS
evx_vmpxl_mask(
  vp_t mask, v16i32_t s1, v16i32_t s2
)
{
  return __builtin_elcore32_vmpxl_mask(mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpyb(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyb(s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpyb_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyb_def_mask(def, mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpyb_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyb_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybhi(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybhi(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybhi_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybhi_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybhi_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybhi_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybhi_rnd(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybhi_rnd(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybhi_rnd_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybhi_rnd_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybhi_rnd_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybhi_rnd_mask(mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpybhl(
  v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpybhl(s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpybhl_def_mask(
  v32i32_t def, vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpybhl_def_mask(def, mask, s1, s2);
}

static __inline__ v32i32_t __DEFAULT_FN_ATTRS
evx_vmpybhl_mask(
  vp_t mask, v64i8_t s1, v32i16_t s2
)
{
  return __builtin_elcore32_vmpybhl_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpyblo(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyblo(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpyblo_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyblo_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpyblo_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyblo_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpyblo_sat(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyblo_sat(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpyblo_sat_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyblo_sat_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpyblo_sat_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpyblo_sat_mask(mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpybu(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybu(s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpybu_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybu_def_mask(def, mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpybu_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybu_mask(mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpybubh(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybubh(s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpybubh_def_mask(
  v64i16_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybubh_def_mask(def, mask, s1, s2);
}

static __inline__ v64i16_t __DEFAULT_FN_ATTRS
evx_vmpybubh_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybubh_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybuhi(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybuhi(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybuhi_def_mask(
  v64i8_t def, vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybuhi_def_mask(def, mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybuhi_mask(
  vp_t mask, v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybuhi_mask(mask, s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybuhi_rnd(
  v64i8_t s1, v64i8_t s2
)
{
  return __builtin_elcore32_vmpybuhi_rnd(s1, s2);
}

static __inline__ v64i8_t __DEFAULT_FN_ATTRS
evx_vmpybuhi_rnd_def_mask(
  v64i