// Copyright 2018-2019 RnD Center "ELVEES", JSC
/*******************************************************************************
 * Copyright (c) 2008-2015 The Khronos Group Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and/or associated documentation files (the
 * "Materials"), to deal in the Materials without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Materials, and to
 * permit persons to whom the Materials are furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Materials.
 *
 * MODIFICATIONS TO THIS FILE MAY MEAN IT NO LONGER ACCURATELY REFLECTS
 * KHRONOS STANDARDS. THE UNMODIFIED, NORMATIVE VERSIONS OF KHRONOS
 * SPECIFICATIONS AND HEADER INFORMATION ARE LOCATED AT
 *    https://www.khronos.org/registry/
 *
 * THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * MATERIALS OR THE USE OR OTHER DEALINGS IN THE MATERIALS.
 ******************************************************************************/

/* $Revision: 11708 $ on $Date: 2010-06-13 23:36:24 -0700 (Sun, 13 Jun 2010) $ */

#ifndef __ELCORE_ECL_H
#define __ELCORE_ECL_H

#ifdef __cplusplus
extern "C" {
#endif

#include <elcorecl/ecl.h>
#include <elcorecl/ecl_gl.h>
#include <elcorecl/ecl_gl_ext.h>
#include <elcorecl/ecl_ext.h>

/* Flush cb bytes for memobj starting from offset byte */
ecl_int eclCachesFlush(ecl_mem           /* memobj */,
                       size_t           /* offset */,
                       size_t           /* cb */);

/* Invalidate cb bytes for memobj starting from offset byte */
ecl_int eclCachesInvalidate(ecl_mem           /* memobj */,
                            size_t           /* offset */,
                            size_t           /* cb */);

/* Flush and Invalidate cb bytes for memobj starting from offset byte */
ecl_int eclCachesFlushInvalidate(ecl_mem           /* memobj */,
                                 size_t           /* offset */,
                                 size_t           /* cb */);

#ifdef __cplusplus
}
#endif

#endif  /* __ELCORE_ECL_H   */
