// SPDX-License-Identifier: MIT
/**
 * Copyright 2022 RnD Center "ELVEES", JSC
 */

#ifndef OMX_VideoElvees_h
#define OMX_VideoElvees_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <OMX_Core.h>

/* DMA buffers support */
#define OMX_ELVEES_INDEX_PARAM_OFFSET   0x00454647

typedef struct OMX_ELVEES_PARAM_ENABLEDMABUFTYPE
{
    OMX_U32 nSize;
    OMX_VERSIONTYPE nVersion;
    OMX_U32 nPortIndex;
    OMX_BOOL bEnabled;
} OMX_ELVEES_PARAM_ENABLEDMABUFTYPE;

enum
{
    OMX_ELVEES_IndexParamEnableDmaBuf = OMX_IndexVendorStartUnused +
                                        OMX_ELVEES_INDEX_PARAM_OFFSET + 5,
};

/* H.265 (HEVC) support */
/* The following macros don't have ELVEES prefix because their names are standard for OpenMAX */
#define OMX_VIDEO_CodingHEVC             0x7F000200
#define OMX_IndexParamVideoHevc          0x6F600008

/* GOP modification support */
/** @brief Params for intra-frame specified in OMX IL 1.2.0
 */
#define OMX_IndexConfigVideoIntraPeriod      0x0600001F

typedef struct OMX_VIDEO_INTRAPERIODTYPE
{
    OMX_U32 nSize;
    OMX_VERSIONTYPE nVersion;
    OMX_U32 nPortIndex;
    OMX_U32 nIDRPeriod;
    OMX_S32 nPFrames;
    OMX_S32 nBFrames;
} OMX_VIDEO_INTRAPERIODTYPE;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
